/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class WiggleMeGraphic
extends GraphicLayerSet
implements ModelElement {
    private static final Font DEFAULT_TEXT_FONT = new PhetFont(18);
    private static final Color DEFAULT_TEXT_COLOR = Color.YELLOW;
    private static final Color DEFAULT_ARROW_FILL_COLOR = Color.YELLOW;
    private static final Color DEFAULT_ARROW_BORDER_COLOR = Color.BLACK;
    private static final Stroke DEFAULT_ARROW_STROKE = new BasicStroke(1.0f);
    private static final Dimension DEFAULT_RANGE = new Dimension(20, 20);
    private BaseModel _model;
    private PhetTextGraphic _textGraphic;
    private Dimension _range;
    private double _cycles;
    private int _cycleDuration;
    private boolean _enabled;
    private Point _startLocation;
    private int _direction;

    public WiggleMeGraphic(Component component, BaseModel baseModel) {
        super(component);
        assert (baseModel != null);
        this._model = baseModel;
        this._textGraphic = new PhetTextGraphic(component, DEFAULT_TEXT_FONT, "", DEFAULT_TEXT_COLOR);
        this._range = new Dimension(DEFAULT_RANGE);
        this._cycles = 0.0;
        this._cycleDuration = 15;
        this._enabled = false;
        this._startLocation = new Point(this.getX(), this.getY());
        this._direction = 0;
        this.addGraphic(this._textGraphic);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setRenderingHints(renderingHints);
    }

    public void setEnabled(boolean bl) {
        if (bl != this._enabled) {
            this._enabled = bl;
            this.setVisible(this._enabled);
            if (this._enabled) {
                this._model.addModelElement(this);
            } else {
                this._model.removeModelElement(this);
            }
        }
    }

    public void setText(String string) {
        this.setText(string, DEFAULT_TEXT_FONT, DEFAULT_TEXT_COLOR);
    }

    public void setText(String string, Font font, Color color) {
        this._textGraphic.setText(string);
        if (font != null) {
            this._textGraphic.setFont(font);
        } else {
            this._textGraphic.setFont(DEFAULT_TEXT_FONT);
        }
        if (color != null) {
            this._textGraphic.setColor(color);
        } else {
            this._textGraphic.setColor(DEFAULT_TEXT_COLOR);
        }
    }

    public void setRange(int n, int n2) {
        this._range.setSize(n, n2);
    }

    public void addArrow(int n, Vector2D vector2D) {
        this.addArrow(n, vector2D, DEFAULT_ARROW_FILL_COLOR, DEFAULT_ARROW_BORDER_COLOR);
    }

    public void addArrow(int n, Vector2D vector2D, Color color, Color color2) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        switch (n) {
            case 0: {
                ((Point2D)double_).setLocation(-10.0, 0.0);
                break;
            }
            case 1: {
                ((Point2D)double_).setLocation(this._textGraphic.getWidth() / 2, 0.0);
                break;
            }
            case 2: {
                ((Point2D)double_).setLocation(this._textGraphic.getWidth() + 10, 0.0);
                break;
            }
            case 3: {
                ((Point2D)double_).setLocation(-10.0, this._textGraphic.getHeight() / 2);
                break;
            }
            case 4: {
                ((Point2D)double_).setLocation(this._textGraphic.getWidth() + 10, this._textGraphic.getHeight() / 2);
                break;
            }
            case 5: {
                ((Point2D)double_).setLocation(-10.0, this._textGraphic.getHeight() + 10);
                break;
            }
            case 6: {
                ((Point2D)double_).setLocation(this._textGraphic.getWidth() / 2, this._textGraphic.getHeight() + 10);
                break;
            }
            case 7: {
                ((Point2D)double_).setLocation(this._textGraphic.getWidth() + 10, this._textGraphic.getHeight() + 10);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal orgin value: " + n);
            }
        }
        Point2D.Double double_2 = new Point2D.Double(((Point2D)double_).getX() + vector2D.getX(), ((Point2D)double_).getY() + vector2D.getY());
        Arrow arrow = new Arrow(double_, double_2, 15.0, 10.0, 3.0, 100.0, false);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent());
        phetShapeGraphic.setShape(arrow.getShape());
        phetShapeGraphic.setPaint(color);
        phetShapeGraphic.setBorderPaint(color2);
        phetShapeGraphic.setStroke(DEFAULT_ARROW_STROKE);
        this.addGraphic(phetShapeGraphic);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this._startLocation.setLocation(n, n2);
    }

    public void stepInTime(double d) {
        if (this._enabled) {
            double d2 = d / (double)this._cycleDuration;
            this._cycles = this._direction == 0 ? (this._cycles += d2) : (this._cycles -= d2);
            int n = (int)((double)this._startLocation.x + (double)this._range.width * Math.cos(this._cycles));
            int n2 = (int)((double)this._startLocation.y + (double)this._range.height * Math.sin(this._cycles));
            super.setLocation(n, n2);
            this.repaint();
        }
    }
}

