/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.model.Voltmeter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class VoltmeterGraphic
extends CompositePhetGraphic
implements SimpleObserver {
    private static final Point PIVOT_POINT = new Point(85, 82);
    private static final Color NEEDLE_COLOR = Color.BLUE;
    private static final Dimension NEEDLE_HEAD_SIZE = new Dimension(12, 15);
    private static final Color SCREW_COLOR = Color.BLUE;
    private Voltmeter _voltmeterModel;
    private PhetShapeGraphic _needle;

    public VoltmeterGraphic(Component component, Voltmeter voltmeter) {
        super(component);
        assert (component != null);
        assert (voltmeter != null);
        this._voltmeterModel = voltmeter;
        this._voltmeterModel.addObserver(this);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Object object = new BackgroundGraphic(component);
        this.addGraphic((PhetGraphic)object);
        object = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_ = new Point2D.Double(0.0, -66.0);
        Arrow arrow = new Arrow((Point2D)object, double_, VoltmeterGraphic.NEEDLE_HEAD_SIZE.height, VoltmeterGraphic.NEEDLE_HEAD_SIZE.width, 3.0);
        this._needle = new PhetShapeGraphic(component);
        this.addGraphic(this._needle);
        this._needle.setShape(arrow.getShape());
        this._needle.setPaint(NEEDLE_COLOR);
        this._needle.setLocation(PIVOT_POINT);
        object = new PhetShapeGraphic(component);
        this.addGraphic((PhetGraphic)object);
        ((PhetShapeGraphic)object).setShape(new Ellipse2D.Double(0.0, 0.0, 9.0, 9.0));
        ((PhetShapeGraphic)object).setPaint(SCREW_COLOR);
        ((PhetGraphic)object).centerRegistrationPoint();
        ((PhetGraphic)object).setLocation(VoltmeterGraphic.PIVOT_POINT.x - 1, VoltmeterGraphic.PIVOT_POINT.y - 1);
        int n = this.getWidth() / 2;
        int n2 = this.getHeight();
        this.setRegistrationPoint(n, n2);
        this.update();
    }

    public void update() {
        this.setVisible(this._voltmeterModel.isEnabled());
        if (this.isVisible()) {
            double d = this._voltmeterModel.getNeedleAngle();
            this._needle.clearTransform();
            this._needle.rotate(d);
            this.repaint();
        }
    }

    private static class BackgroundGraphic
    extends PhetImageGraphic {
        private static final Color GUAGE_COLOR = Color.BLACK;
        private static final Stroke GUAGE_STROKE = new BasicStroke(1.0f);
        private static final Font TITLE_FONT = new PhetFont(14);
        private static final Color TITLE_COLOR = Color.WHITE;
        private static final Color MAJOR_TICK_COLOR = Color.BLACK;
        private static final Color MINOR_TICK_COLOR = Color.BLACK;
        private static final Stroke MAJOR_TICK_STROKE;
        private static final Stroke MINOR_TICK_STROKE;

        public BackgroundGraphic(Component component) {
            super(component);
            PhetGraphic phetGraphic;
            Object object;
            Object object2;
            GraphicLayerSet graphicLayerSet = new GraphicLayerSet(component);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphicLayerSet.setRenderingHints(renderingHints);
            BufferedImage bufferedImage = FaradayResources.getImage("voltmeter.png");
            PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, bufferedImage);
            graphicLayerSet.addGraphic(phetImageGraphic, 3.0);
            PhetGraphic phetGraphic2 = new PhetTextGraphic(component, TITLE_FONT, FaradayStrings.TITLE_VOLTMETER, TITLE_COLOR);
            phetGraphic2.centerRegistrationPoint();
            phetGraphic2.setLocation(phetImageGraphic.getWidth() / 2, phetImageGraphic.getHeight() + 3);
            graphicLayerSet.addGraphic(phetGraphic2, 4.0);
            phetGraphic2 = new PhetShapeGraphic(component);
            double d = 132.0;
            ((PhetShapeGraphic)phetGraphic2).setShape(new Arc2D.Double(0.0, 0.0, d, d, 0.0, 180.0, 1));
            ((PhetShapeGraphic)phetGraphic2).setBorderColor(GUAGE_COLOR);
            ((PhetShapeGraphic)phetGraphic2).setStroke(GUAGE_STROKE);
            phetGraphic2.setRegistrationPoint((int)(d / 2.0), (int)(d / 2.0));
            phetGraphic2.setLocation(PIVOT_POINT);
            graphicLayerSet.addGraphic(phetGraphic2, 5.0);
            phetGraphic2 = new PhetShapeGraphic(component);
            ((PhetShapeGraphic)phetGraphic2).setShape(new Line2D.Double(0.0, 0.0, 0.0, -66.0));
            ((PhetShapeGraphic)phetGraphic2).setBorderColor(GUAGE_COLOR);
            ((PhetShapeGraphic)phetGraphic2).setStroke(GUAGE_STROKE);
            phetGraphic2.setLocation(PIVOT_POINT);
            graphicLayerSet.addGraphic(phetGraphic2, 5.0);
            double d2 = 4.5;
            double d3 = 1.0;
            while (d2 < 90.0) {
                int n = 4;
                object2 = MINOR_TICK_COLOR;
                object = MINOR_TICK_STROKE;
                if (d3 % 4.0 == 0.0) {
                    n = 8;
                    object2 = MAJOR_TICK_COLOR;
                    object = MAJOR_TICK_STROKE;
                }
                phetGraphic = new PhetShapeGraphic(component);
                ((PhetShapeGraphic)phetGraphic).setShape(new Line2D.Double(0.0, 1.0, 0.0, n));
                ((PhetShapeGraphic)phetGraphic).setBorderColor((Color)object2);
                ((PhetShapeGraphic)phetGraphic).setStroke((Stroke)object);
                phetGraphic.setLocation(PIVOT_POINT);
                phetGraphic.translate(0.0, -66.0);
                phetGraphic.rotate(Math.toRadians(d2));
                graphicLayerSet.addGraphic(phetGraphic, 5.0);
                PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
                phetShapeGraphic.setShape(new Line2D.Double(0.0, 1.0, 0.0, n));
                phetShapeGraphic.setBorderColor((Color)object2);
                phetShapeGraphic.setStroke((Stroke)object);
                phetShapeGraphic.setLocation(PIVOT_POINT);
                phetShapeGraphic.translate(0.0, -66.0);
                phetShapeGraphic.rotate(Math.toRadians(-d2));
                graphicLayerSet.addGraphic(phetShapeGraphic, 5.0);
                d2 += 4.5;
                d3 += 1.0;
            }
            BufferedImage bufferedImage2 = FaradayResources.getImage("resistor.png");
            PhetImageGraphic phetImageGraphic2 = new PhetImageGraphic(component, bufferedImage2);
            phetImageGraphic2.centerRegistrationPoint();
            phetImageGraphic2.setLocation(phetImageGraphic.getWidth() / 2, phetImageGraphic.getHeight() + 40);
            graphicLayerSet.addGraphic(phetImageGraphic2, 1.0);
            int n = 53;
            int n2 = phetImageGraphic.getHeight() - 52;
            Object object3 = FaradayResources.getImage("voltmeterProbeWhite.png");
            object2 = new PhetImageGraphic(component, (BufferedImage)object3);
            ((PhetGraphic)object2).setLocation(n, n2);
            graphicLayerSet.addGraphic((PhetGraphic)object2, 2.0);
            object = FaradayResources.getImage("voltmeterProbeBlack.png");
            phetGraphic = new PhetImageGraphic(component, (BufferedImage)object);
            phetGraphic.setLocation(n + phetImageGraphic2.getWidth() + 2, ((PhetGraphic)object2).getY());
            graphicLayerSet.addGraphic(phetGraphic, 2.0);
            Dimension dimension = graphicLayerSet.getSize();
            BufferedImage bufferedImage3 = new BufferedImage(dimension.width, dimension.height, 2);
            object3 = bufferedImage3.createGraphics();
            graphicLayerSet.paint((Graphics2D)object3);
            this.setImage(bufferedImage3);
        }

        static {
            MINOR_TICK_STROKE = MAJOR_TICK_STROKE = new BasicStroke(1.0f);
        }
    }
}

