/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.FaradaySlider;
import edu.colorado.phet.faraday.model.Turbine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TurbineGraphic
extends GraphicLayerSet
implements SimpleObserver,
ApparatusPanel2.ChangeListener {
    private static final Color RPM_COLOR = Color.GREEN;
    private static final Font RPM_VALUE_FONT = new PhetFont(15);
    private static final Font RPM_UNITS_FONT = new PhetFont(12);
    private static final Color WATER_COLOR = new Color(194, 234, 255, 180);
    private Rectangle _parentBounds;
    private Turbine _turbineModel;
    private PhetShapeGraphic _waterGraphic;
    private Rectangle2D _waterShape;
    private PhetImageGraphic _barMagnetGraphic;
    private PhetImageGraphic _waterWheelGraphic;
    private PhetTextGraphic _rpmValue;
    private FaradaySlider _flowSlider;
    private double _previousSpeed;

    public TurbineGraphic(Component component, Turbine turbine) {
        super(component);
        assert (turbine != null);
        this._turbineModel = turbine;
        this._turbineModel.addObserver(this);
        this._parentBounds = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        Object object = FaradayResources.getImage("faucet.png");
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, (BufferedImage)object);
        this.addGraphic(phetImageGraphic, 3.0);
        phetImageGraphic.setLocation(-405, -350);
        phetImageGraphic.setIgnoreMouse(true);
        this._waterGraphic = new PhetShapeGraphic(component);
        this._waterGraphic.setIgnoreMouse(true);
        this.addGraphic(this._waterGraphic, 2.0);
        this._waterGraphic.setPaint(WATER_COLOR);
        this._waterShape = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        this._waterGraphic.setShape(this._waterShape);
        this._waterGraphic.setLocation(-112, -245);
        this._flowSlider = new FaradaySlider(component, 70);
        this.addGraphic(this._flowSlider, 4.0);
        this._flowSlider.setMinimum(0);
        this._flowSlider.setMaximum(100);
        this._flowSlider.setValue(0);
        this._flowSlider.centerRegistrationPoint();
        this._flowSlider.setLocation(-160, -335);
        this._flowSlider.addChangeListener(new SliderListener());
        object = FaradayResources.getImage("waterWheel.png");
        this._waterWheelGraphic = new PhetImageGraphic(component, (BufferedImage)object);
        this._waterWheelGraphic.setIgnoreMouse(true);
        this._waterWheelGraphic.centerRegistrationPoint();
        this._waterWheelGraphic.setLocation(0, 0);
        this.addGraphic(this._waterWheelGraphic, 1.0);
        object = FaradayResources.getImage("barMagnet.png");
        this._barMagnetGraphic = new PhetImageGraphic(component, (BufferedImage)object);
        this._barMagnetGraphic.setIgnoreMouse(true);
        this._barMagnetGraphic.centerRegistrationPoint();
        this._barMagnetGraphic.setLocation(0, 0);
        this.addGraphic(this._barMagnetGraphic, 5.0);
        double d = this._turbineModel.getWidth() / (double)this._barMagnetGraphic.getWidth();
        double d2 = this._turbineModel.getHeight() / (double)this._barMagnetGraphic.getHeight();
        this._barMagnetGraphic.scale(d, d2);
        object = FaradayResources.getImage("turbinePivot.png");
        PhetGraphic phetGraphic = new PhetImageGraphic(component, (BufferedImage)object);
        phetGraphic.setIgnoreMouse(true);
        this.addGraphic(phetGraphic, 6.0);
        phetGraphic.centerRegistrationPoint();
        phetGraphic.setLocation(0, 0);
        object = String.valueOf((int)this._turbineModel.getRPM());
        this._rpmValue = new PhetTextGraphic(component, RPM_VALUE_FONT, (String)object, RPM_COLOR);
        this.addGraphic(this._rpmValue, 7.0);
        this._rpmValue.centerRegistrationPoint();
        this._rpmValue.setLocation(0, 10);
        this._rpmValue.setIgnoreMouse(true);
        phetGraphic = new PhetTextGraphic(component, RPM_UNITS_FONT, FaradayStrings.UNITS_RPM, RPM_COLOR);
        this.addGraphic(phetGraphic, 7.0);
        phetGraphic.centerRegistrationPoint();
        phetGraphic.setLocation(0, 22);
        phetGraphic.setIgnoreMouse(true);
        this._previousSpeed = 0.0;
        this.update();
    }

    public void update() {
        if (this.isVisible()) {
            this.setLocation((int)this._turbineModel.getX(), (int)this._turbineModel.getY());
            double d = this._turbineModel.getSpeed();
            if (d != 0.0) {
                double d2 = this._turbineModel.getDirection();
                this._barMagnetGraphic.clearTransform();
                this._barMagnetGraphic.rotate(d2);
                this._waterWheelGraphic.clearTransform();
                this._waterWheelGraphic.rotate(d2);
            }
            if (d != this._previousSpeed) {
                this._previousSpeed = d;
                int n = (int)this._turbineModel.getRPM();
                this._rpmValue.setText(String.valueOf(n));
                this._rpmValue.centerRegistrationPoint();
                this.updateWater(d);
                if (-d * 100.0 != (double)this._flowSlider.getValue()) {
                    this._flowSlider.setValue((int)(-d * 100.0));
                }
            }
            this.repaint();
        }
    }

    private void updateWater(double d) {
        if (d == 0.0) {
            this._waterGraphic.setShape(null);
        } else {
            double d2 = Math.abs(d * 40.0);
            if (d2 < 1.0) {
                d2 = 1.0;
            }
            this._waterShape.setRect(-(d2 / 2.0), 0.0, d2, this._parentBounds.height);
            this._waterGraphic.setShape(this._waterShape);
            this.setBoundsDirty();
        }
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._parentBounds.setBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
        this.updateWater(this._turbineModel.getSpeed());
    }

    private class SliderListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == TurbineGraphic.this._flowSlider) {
                double d = -((double)TurbineGraphic.this._flowSlider.getValue() / 100.0);
                TurbineGraphic.this._turbineModel.setSpeed(d);
            }
        }
    }
}

