/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.faraday.model.PickupCoil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class PickupCoilSamplePointsGraphic
extends CompositePhetGraphic
implements SimpleObserver {
    private static final Color POINT_COLOR = Color.YELLOW;
    private static final Shape POINT_SHAPE = new Ellipse2D.Double(-2.0, 2.0, 4.0, 4.0);
    private PickupCoil _pickupCoilModel;

    public PickupCoilSamplePointsGraphic(Component component, PickupCoil pickupCoil) {
        super(component);
        this._pickupCoilModel = pickupCoil;
        this._pickupCoilModel.addObserver(this);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }

    public void update() {
        if (this.isVisible()) {
            this.clear();
            Point2D[] point2DArray = this._pickupCoilModel.getSamplePoints();
            Component component = this.getComponent();
            for (int i = 0; i < point2DArray.length; ++i) {
                PhetGraphic phetGraphic = PickupCoilSamplePointsGraphic.createGraphic(component, (int)point2DArray[i].getX(), (int)point2DArray[i].getY());
                this.addGraphic(phetGraphic);
            }
        }
    }

    private static PhetGraphic createGraphic(Component component, int n, int n2) {
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setShape(POINT_SHAPE);
        phetShapeGraphic.setColor(POINT_COLOR);
        phetShapeGraphic.centerRegistrationPoint();
        phetShapeGraphic.setLocation(n, n2);
        return phetShapeGraphic;
    }
}

