/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.model.BarMagnet;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;

public class EarthGraphic
extends PhetImageGraphic
implements SimpleObserver {
    private static final Composite COMPOSITE = AlphaComposite.getInstance(3, 0.75f);
    private BarMagnet _barMagnetModel;

    public EarthGraphic(Component component, BarMagnet barMagnet) {
        super(component, FaradayResources.getImage("earth.png"));
        this.setIgnoreMouse(true);
        this._barMagnetModel = barMagnet;
        this._barMagnetModel.addObserver(this);
        this.centerRegistrationPoint();
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.update();
    }

    public void update() {
        if (this.isVisible()) {
            this.clearTransform();
            this.scale(0.6);
            this.rotate(this._barMagnetModel.getDirection() + -1.5707963267948966);
            this.setLocation((int)this._barMagnetModel.getX(), (int)this._barMagnetModel.getY());
            this.repaint();
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(COMPOSITE);
            super.paint(graphics2D);
            graphics2D.setComposite(composite);
        }
    }
}

