/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.faraday.collision.CollisionDetector;
import edu.colorado.phet.faraday.collision.ICollidable;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.view.CompassNeedleCache;
import edu.colorado.phet.faraday.view.FaradayMouseHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class CompassGraphic
extends CompositePhetGraphic
implements SimpleObserver,
ApparatusPanel2.ChangeListener,
ICollidable {
    private static final Dimension NEEDLE_SIZE = new Dimension(55, 15);
    private static final Color RING_COLOR = new Color(153, 153, 153);
    private static final Color LENS_COLOR = new Color(255, 255, 255, 15);
    private static final Color INDICATOR_COLOR = Color.BLACK;
    private static final Color ANCHOR_COLOR = Color.BLACK;
    private Compass _compassModel;
    private PhetShapeGraphic _needleNorthGraphic;
    private PhetShapeGraphic _needleSouthGraphic;
    private CompassNeedleCache _needleCache;
    private CollisionDetector _collisionDetector;
    private Ellipse2D[] _collisionBounds;
    private FaradayMouseHandler _mouseHandler;

    public CompassGraphic(Component component, Compass compass) {
        super(component);
        assert (component != null);
        assert (compass != null);
        this._compassModel = compass;
        this._compassModel.addObserver(this);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BodyGraphic bodyGraphic = new BodyGraphic(component);
        bodyGraphic.centerRegistrationPoint();
        this.addGraphic(bodyGraphic);
        this._needleCache = new CompassNeedleCache(NEEDLE_SIZE);
        Serializable serializable = this._needleCache.getNorthColor(1.0);
        Object object = this._needleCache.getNorthShape(this._compassModel.getDirection());
        this._needleNorthGraphic = new PhetShapeGraphic(component);
        this._needleNorthGraphic.setColor((Color)serializable);
        this._needleNorthGraphic.setShape((Shape)object);
        this.addGraphic(this._needleNorthGraphic);
        Color color = this._needleCache.getSouthColor(1.0);
        Shape shape = this._needleCache.getSouthShape(this._compassModel.getDirection());
        this._needleSouthGraphic = new PhetShapeGraphic(component);
        this._needleSouthGraphic.setColor(color);
        this._needleSouthGraphic.setShape(shape);
        this.addGraphic(this._needleSouthGraphic);
        serializable = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        object = new PhetShapeGraphic(component);
        ((PhetShapeGraphic)object).setShape((Shape)((Object)serializable));
        ((PhetShapeGraphic)object).setPaint(ANCHOR_COLOR);
        this.addGraphic((PhetGraphic)object);
        this._mouseHandler = new FaradayMouseHandler(this._compassModel, this);
        this._collisionDetector = new CollisionDetector(this);
        this._mouseHandler.setCollisionDetector(this._collisionDetector);
        super.setCursorHand();
        super.addMouseInputListener(this._mouseHandler);
        this.update();
    }

    public void update() {
        super.setVisible(this._compassModel.isEnabled());
        if (this.isVisible()) {
            double d = this._compassModel.getDirection();
            Shape shape = this._needleCache.getNorthShape(d);
            Shape shape2 = this._needleCache.getSouthShape(d);
            this._needleNorthGraphic.setShape(shape);
            this._needleSouthGraphic.setShape(shape2);
            this.setLocation((int)this._compassModel.getX(), (int)this._compassModel.getY());
        }
    }

    public CollisionDetector getCollisionDetector() {
        return this._collisionDetector;
    }

    public Shape[] getCollisionBounds() {
        if (this.isVisible()) {
            if (this._collisionBounds == null) {
                this._collisionBounds = new Ellipse2D.Double[1];
                this._collisionBounds[0] = new Ellipse2D.Double();
            }
            double d = this.getX() - 40;
            double d2 = this.getY() - 40;
            this._collisionBounds[0].setFrame(d, d2, 80.0, 80.0);
            return this._collisionBounds;
        }
        return null;
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._mouseHandler.setDragBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
    }

    private static class BodyGraphic
    extends PhetImageGraphic {
        public BodyGraphic(Component component) {
            super(component);
            Serializable serializable;
            GraphicLayerSet graphicLayerSet = new GraphicLayerSet(component);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphicLayerSet.setRenderingHints(renderingHints);
            double d = 70.0;
            Ellipse2D.Double double_ = new Ellipse2D.Double(-d / 2.0, -d / 2.0, d, d);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
            phetShapeGraphic.setShape(double_);
            phetShapeGraphic.setPaint(LENS_COLOR);
            phetShapeGraphic.setBorderColor(RING_COLOR);
            phetShapeGraphic.setStroke(new BasicStroke(10.0f));
            graphicLayerSet.addGraphic(phetShapeGraphic);
            PhetShapeGraphic phetShapeGraphic2 = null;
            Ellipse2D.Double double_2 = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
            for (int i = 0; i < 360; i += 45) {
                phetShapeGraphic2 = new PhetShapeGraphic(component);
                phetShapeGraphic2.setShape(double_2);
                phetShapeGraphic2.setPaint(INDICATOR_COLOR);
                serializable = ImmutableVector2D.parseAngleAndMagnitude(d / 2.0, Math.toRadians(i));
                int n = (int)((ImmutableVector2D)serializable).getX();
                int n2 = (int)((ImmutableVector2D)serializable).getY();
                phetShapeGraphic2.setRegistrationPoint(n, n2);
                graphicLayerSet.addGraphic(phetShapeGraphic2);
            }
            serializable = graphicLayerSet.getSize();
            BufferedImage bufferedImage = new BufferedImage(((Dimension)serializable).width, ((Dimension)serializable).height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphicLayerSet.translate(((Dimension)serializable).width / 2, ((Dimension)serializable).height / 2);
            graphicLayerSet.paint(graphics2D);
            this.setImage(bufferedImage);
        }
    }
}

