/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.collision.CollisionDetector;
import edu.colorado.phet.faraday.collision.ICollidable;
import edu.colorado.phet.faraday.model.BarMagnet;
import edu.colorado.phet.faraday.view.FaradayMouseHandler;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;

public class BarMagnetGraphic
extends PhetImageGraphic
implements SimpleObserver,
ApparatusPanel2.ChangeListener,
ICollidable {
    private BarMagnet _barMagnetModel;
    private CollisionDetector _collisionDetector;
    private Rectangle[] _collisionBounds;
    private FaradayMouseHandler _mouseHandler;

    public BarMagnetGraphic(Component component, BarMagnet barMagnet) {
        super(component, FaradayResources.getImage("barMagnet.png"));
        assert (component != null);
        assert (barMagnet != null);
        this._barMagnetModel = barMagnet;
        this._barMagnetModel.addObserver(this);
        this.centerRegistrationPoint();
        this._mouseHandler = new FaradayMouseHandler(this._barMagnetModel, this);
        this._collisionDetector = new CollisionDetector(this);
        this._mouseHandler.setCollisionDetector(this._collisionDetector);
        super.setCursorHand();
        super.addMouseInputListener(this._mouseHandler);
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.update();
    }

    public void update() {
        if (this.isVisible()) {
            this.clearTransform();
            double d = this._barMagnetModel.getWidth() / (double)this.getWidth();
            double d2 = this._barMagnetModel.getHeight() / (double)this.getHeight();
            this.scale(d, d2);
            if (this._barMagnetModel.getDirection() != 0.0) {
                this.rotate(this._barMagnetModel.getDirection());
            }
            this.setLocation((int)this._barMagnetModel.getX(), (int)this._barMagnetModel.getY());
            this.repaint();
        }
    }

    public CollisionDetector getCollisionDetector() {
        return this._collisionDetector;
    }

    public Shape[] getCollisionBounds() {
        if (this.isVisible()) {
            if (this._collisionBounds == null) {
                this._collisionBounds = new Rectangle[1];
                this._collisionBounds[0] = new Rectangle();
            }
            this._collisionBounds[0].setBounds(this.getBounds());
            return this._collisionBounds;
        }
        return null;
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._mouseHandler.setDragBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
    }
}

