/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.faraday.model.AbstractMagnet;
import edu.colorado.phet.faraday.view.AbstractBFieldGraphic;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;

public class BFieldOutsideGraphic
extends AbstractBFieldGraphic
implements SimpleObserver,
ApparatusPanel2.ChangeListener {
    private AbstractMagnet _magnetModel;

    public BFieldOutsideGraphic(Component component, AbstractMagnet abstractMagnet, int n, int n2) {
        super(component, abstractMagnet, n, n2);
        this._magnetModel = abstractMagnet;
        this._magnetModel.addObserver(this);
    }

    protected AbstractBFieldGraphic.GridPoint[] createGridPoints() {
        ArrayList<AbstractBFieldGraphic.GridPoint> arrayList = new ArrayList<AbstractBFieldGraphic.GridPoint>();
        Rectangle rectangle = this.getGridBoundsReference();
        int n = this.getXSpacing();
        int n2 = this.getYSpacing();
        int n3 = rectangle.width / n + 1;
        int n4 = rectangle.height / n2 + 1;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                double d = rectangle.getX() + (double)(i * n);
                double d2 = rectangle.getY() + (double)(j * n2);
                arrayList.add(new AbstractBFieldGraphic.GridPoint(d, d2));
            }
        }
        return arrayList.toArray(new AbstractBFieldGraphic.GridPoint[arrayList.size()]);
    }

    public void update() {
        this.updateStrengthAndOrientation();
        this.repaint();
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        Dimension dimension = changeEvent.getCanvasSize();
        this.setGridBounds(0, 0, dimension.width, dimension.height);
        super.setBoundsDirty();
    }
}

