/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic2;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.FaradaySlider;
import edu.colorado.phet.faraday.model.ACPowerSupply;
import edu.colorado.phet.faraday.view.SineWaveGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ACPowerSupplyGraphic
extends GraphicLayerSet
implements SimpleObserver {
    private static final Font VALUE_FONT = new PhetFont(12);
    private static final Color VALUE_COLOR = Color.GREEN;
    private static final Dimension WAVE_VIEWPORT_SIZE = new Dimension(156, 122);
    private static final Point WAVE_ORIGIN = new Point(133, 103);
    private static final Color CURSOR_COLOR = Color.RED;
    private static final Stroke CURSOR_STROKE = new BasicStroke(1.0f);
    private static final double CURSOR_WRAP_AROUND_TOLERANCE = Math.toRadians(5.0);
    private ACPowerSupply _acPowerSupplyModel;
    private FaradaySlider _maxAmplitudeSlider;
    private FaradaySlider _frequencySlider;
    private PhetTextGraphic2 _maxAmplitudeValue;
    private PhetTextGraphic2 _frequencyValue;
    private PhetTextGraphic2 _debugAmplitudeValue;
    private SineWaveGraphic _waveGraphic;
    private PhetShapeGraphic _cursorGraphic;
    private double _previousMaxAmplitude;
    private double _previousFrequency;
    private double _cursorAngle;

    public ACPowerSupplyGraphic(Component component, ACPowerSupply aCPowerSupply) {
        super(component);
        assert (component != null);
        assert (aCPowerSupply != null);
        this._acPowerSupplyModel = aCPowerSupply;
        this._acPowerSupplyModel.addObserver(this);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setRenderingHints(renderingHints);
        BackgroundGraphic backgroundGraphic = new BackgroundGraphic(component);
        this._maxAmplitudeSlider = new FaradaySlider(component, 100);
        this._maxAmplitudeSlider.setMinimum(0);
        this._maxAmplitudeSlider.setMaximum(100);
        this._maxAmplitudeSlider.setValue((int)(100.0 * this._acPowerSupplyModel.getMaxAmplitude()));
        this._maxAmplitudeSlider.centerRegistrationPoint();
        this._maxAmplitudeSlider.rotate(-1.5707963267948966);
        this._maxAmplitudeSlider.setLocation(32, 130);
        this._maxAmplitudeSlider.addChangeListener(new SliderListener());
        this._maxAmplitudeValue = new PhetTextGraphic2(component, VALUE_FONT, "", VALUE_COLOR);
        this._maxAmplitudeValue.setLocation(45, 57);
        this._debugAmplitudeValue = new PhetTextGraphic2(component, VALUE_FONT, "", Color.RED);
        this._debugAmplitudeValue.setLocation(90, 57);
        this._debugAmplitudeValue.setVisible(false);
        this._frequencySlider = new FaradaySlider(component, 100);
        this._frequencySlider.setMinimum(5);
        this._frequencySlider.setMaximum(100);
        this._frequencySlider.setValue((int)(100.0 * this._acPowerSupplyModel.getFrequency()));
        this._frequencySlider.centerRegistrationPoint();
        this._frequencySlider.setLocation(102, 190);
        this._frequencySlider.addChangeListener(new SliderListener());
        this._frequencyValue = new PhetTextGraphic2(component, VALUE_FONT, " ", VALUE_COLOR);
        this._frequencyValue.setLocation(210, 193);
        this._waveGraphic = new SineWaveGraphic(component, WAVE_VIEWPORT_SIZE);
        this._waveGraphic.setMaxCycles(20.0);
        this._waveGraphic.setLocation(WAVE_ORIGIN);
        int n = ACPowerSupplyGraphic.WAVE_VIEWPORT_SIZE.height / 2;
        Line2D.Double double_ = new Line2D.Double(0.0, -n, 0.0, n);
        this._cursorGraphic = new PhetShapeGraphic(component);
        this._cursorGraphic.setShape(double_);
        this._cursorGraphic.setBorderColor(CURSOR_COLOR);
        this._cursorGraphic.setStroke(CURSOR_STROKE);
        int n2 = ACPowerSupplyGraphic.WAVE_ORIGIN.x - ACPowerSupplyGraphic.WAVE_VIEWPORT_SIZE.width / 2;
        int n3 = ACPowerSupplyGraphic.WAVE_ORIGIN.y;
        this._cursorGraphic.setLocation(n2, n3);
        this._cursorGraphic.setVisible(false);
        this.addGraphic(backgroundGraphic, 1.0);
        this.addGraphic(this._maxAmplitudeSlider, 2.0);
        this.addGraphic(this._frequencySlider, 2.0);
        this.addGraphic(this._debugAmplitudeValue, 5.0);
        this.addGraphic(this._maxAmplitudeValue, 3.0);
        this.addGraphic(this._frequencyValue, 3.0);
        this.addGraphic(this._waveGraphic, 4.0);
        this.addGraphic(this._cursorGraphic, 5.0);
        n = this.getWidth() / 2;
        int n4 = this.getHeight();
        this.setRegistrationPoint(n, n4);
        this._cursorAngle = 0.0;
        this._previousFrequency = -2.0;
        this._previousMaxAmplitude = -2.0;
        this.update();
    }

    public void update() {
        this.setVisible(this._acPowerSupplyModel.isEnabled());
        if (this.isVisible()) {
            double d = this._acPowerSupplyModel.getAmplitude();
            double d2 = this._acPowerSupplyModel.getMaxAmplitude();
            double d3 = this._acPowerSupplyModel.getFrequency();
            if (d2 == this._previousMaxAmplitude && d3 == this._previousFrequency) {
                this.updateCursor();
                if (this._debugAmplitudeValue.isVisible()) {
                    int n = (int)(d * 100.0);
                    Object[] objectArray = new Object[]{new Integer(n)};
                    String string = MessageFormat.format("{0}%", objectArray);
                    this._debugAmplitudeValue.setText(string);
                    int n2 = this._debugAmplitudeValue.getBounds().width;
                    int n3 = this._debugAmplitudeValue.getBounds().height;
                    this._debugAmplitudeValue.setRegistrationPoint(n2, n3);
                }
            } else {
                int n;
                int n4;
                String string;
                Object[] objectArray;
                int n5;
                this._cursorAngle = 0.0;
                this._cursorGraphic.setVisible(false);
                this._waveGraphic.setAmplitude(d2);
                this._waveGraphic.setFrequency(d3);
                this._waveGraphic.update();
                if (d2 != this._previousMaxAmplitude) {
                    n5 = (int)(d2 * 100.0);
                    objectArray = new Object[]{new Integer(n5)};
                    string = MessageFormat.format("{0}%", objectArray);
                    this._maxAmplitudeValue.setText(string);
                    n4 = this._maxAmplitudeValue.getBounds().width;
                    n = this._maxAmplitudeValue.getBounds().height;
                    this._maxAmplitudeValue.setRegistrationPoint(n4, n);
                    if (n5 != this._maxAmplitudeSlider.getValue()) {
                        this._maxAmplitudeSlider.setValue(n5);
                    }
                }
                if (d3 != this._previousFrequency) {
                    n5 = (int)(100.0 * d3);
                    objectArray = new Object[]{new Integer(n5)};
                    string = MessageFormat.format("{0}%", objectArray);
                    this._frequencyValue.setText(string);
                    n4 = this._frequencyValue.getBounds().width;
                    n = this._frequencyValue.getBounds().height;
                    this._frequencyValue.setRegistrationPoint(n4, n);
                    if (n5 != this._frequencySlider.getValue()) {
                        this._frequencySlider.setValue(n5);
                    }
                }
                this._previousMaxAmplitude = d2;
                this._previousFrequency = d3;
            }
            this.repaint();
        }
    }

    private void updateCursor() {
        double d = this._waveGraphic.getStartAngle();
        double d2 = this._waveGraphic.getEndAngle();
        double d3 = this._acPowerSupplyModel.getStepAngle();
        this._cursorAngle += d3;
        if (this._cursorAngle < d) {
            this._cursorGraphic.setVisible(false);
        } else if (this._cursorAngle >= d2) {
            this._cursorGraphic.setVisible(false);
            this._cursorAngle %= Math.PI * 2;
            if (this._cursorAngle > d + CURSOR_WRAP_AROUND_TOLERANCE) {
                this._cursorAngle -= Math.PI * 2;
            }
        }
        if (this._cursorAngle >= d && this._cursorAngle < d2) {
            this._cursorGraphic.setVisible(true);
            double d4 = ACPowerSupplyGraphic.WAVE_ORIGIN.x - ACPowerSupplyGraphic.WAVE_VIEWPORT_SIZE.width / 2;
            double d5 = (this._cursorAngle - d) / (d2 - d);
            double d6 = d4 + d5 * (double)ACPowerSupplyGraphic.WAVE_VIEWPORT_SIZE.width;
            int n = ACPowerSupplyGraphic.WAVE_ORIGIN.y;
            this._cursorGraphic.setLocation((int)d6, n);
        }
    }

    private static class BackgroundGraphic
    extends PhetImageGraphic {
        private static final Font TITLE_FONT = new PhetFont(15);
        private static final Color TITLE_COLOR = Color.WHITE;
        private static final Stroke AXES_STROKE = new BasicStroke(1.0f);
        private static final Color AXES_COLOR = new Color(255, 255, 255, 100);
        private static final Stroke TICK_STROKE = AXES_STROKE;
        private static final Color TICK_COLOR = AXES_COLOR;

        public BackgroundGraphic(Component component) {
            super(component);
            PhetShapeGraphic phetShapeGraphic;
            PhetShapeGraphic phetShapeGraphic2;
            int n;
            GraphicLayerSet graphicLayerSet = new GraphicLayerSet(component);
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphicLayerSet.setRenderingHints(renderingHints);
            BufferedImage bufferedImage = FaradayResources.getImage("acPowerSupply.png");
            PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, bufferedImage);
            graphicLayerSet.addGraphic(phetImageGraphic, 1.0);
            PhetTextGraphic phetTextGraphic = new PhetTextGraphic(component, TITLE_FONT, FaradayStrings.TITLE_AC_POWER_SUPPLY, TITLE_COLOR);
            graphicLayerSet.addGraphic(phetTextGraphic, 2.0);
            phetTextGraphic.centerRegistrationPoint();
            phetTextGraphic.setLocation(phetImageGraphic.getWidth() / 2, 36);
            int n2 = WAVE_VIEWPORT_SIZE.width;
            int n3 = WAVE_VIEWPORT_SIZE.height;
            Object object = new PhetShapeGraphic(component);
            ((PhetShapeGraphic)object).setShape(new Line2D.Double(-n2 / 2, 0.0, n2 / 2, 0.0));
            ((PhetShapeGraphic)object).setBorderColor(AXES_COLOR);
            ((PhetShapeGraphic)object).setStroke(AXES_STROKE);
            ((PhetGraphic)object).setLocation(WAVE_ORIGIN);
            graphicLayerSet.addGraphic((PhetGraphic)object, 3.0);
            int n4 = 4;
            for (n = 10; n < n2 / 2; n += 10) {
                phetShapeGraphic2 = new PhetShapeGraphic(component);
                phetShapeGraphic2.setShape(new Line2D.Double(n, -n4, n, n4));
                phetShapeGraphic2.setBorderColor(TICK_COLOR);
                phetShapeGraphic2.setStroke(TICK_STROKE);
                phetShapeGraphic2.setLocation(WAVE_ORIGIN);
                graphicLayerSet.addGraphic(phetShapeGraphic2, 4.0);
                phetShapeGraphic = new PhetShapeGraphic(component);
                phetShapeGraphic.setShape(new Line2D.Double(-n, -n4, -n, n4));
                phetShapeGraphic.setBorderColor(TICK_COLOR);
                phetShapeGraphic.setStroke(TICK_STROKE);
                phetShapeGraphic.setLocation(WAVE_ORIGIN);
                graphicLayerSet.addGraphic(phetShapeGraphic, 4.0);
            }
            object = new PhetShapeGraphic(component);
            ((PhetShapeGraphic)object).setShape(new Line2D.Double(0.0, -n3 / 2, 0.0, n3 / 2));
            ((PhetShapeGraphic)object).setBorderColor(AXES_COLOR);
            ((PhetShapeGraphic)object).setStroke(AXES_STROKE);
            ((PhetGraphic)object).setLocation(WAVE_ORIGIN);
            graphicLayerSet.addGraphic((PhetGraphic)object, 3.0);
            n = 4;
            for (n4 = 10; n4 < n3 / 2; n4 += 10) {
                phetShapeGraphic2 = new PhetShapeGraphic(component);
                phetShapeGraphic2.setShape(new Line2D.Double(-n, n4, n, n4));
                phetShapeGraphic2.setBorderColor(TICK_COLOR);
                phetShapeGraphic2.setStroke(TICK_STROKE);
                phetShapeGraphic2.setLocation(WAVE_ORIGIN);
                graphicLayerSet.addGraphic(phetShapeGraphic2, 4.0);
                phetShapeGraphic = new PhetShapeGraphic(component);
                phetShapeGraphic.setShape(new Line2D.Double(-n, -n4, n, -n4));
                phetShapeGraphic.setBorderColor(TICK_COLOR);
                phetShapeGraphic.setStroke(TICK_STROKE);
                phetShapeGraphic.setLocation(WAVE_ORIGIN);
                graphicLayerSet.addGraphic(phetShapeGraphic, 4.0);
            }
            Dimension dimension = graphicLayerSet.getSize();
            BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, 2);
            object = bufferedImage2.createGraphics();
            graphicLayerSet.paint((Graphics2D)object);
            this.setImage(bufferedImage2);
        }
    }

    private class SliderListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == ACPowerSupplyGraphic.this._maxAmplitudeSlider) {
                double d = (double)ACPowerSupplyGraphic.this._maxAmplitudeSlider.getValue() / 100.0;
                ACPowerSupplyGraphic.this._acPowerSupplyModel.setMaxAmplitude(d);
            } else if (changeEvent.getSource() == ACPowerSupplyGraphic.this._frequencySlider) {
                double d = (double)ACPowerSupplyGraphic.this._frequencySlider.getValue() / 100.0;
                ACPowerSupplyGraphic.this._acPowerSupplyModel.setFrequency(d);
            }
        }
    }
}

