/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.util;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class VariableAlphaImageGraphic
extends PhetImageGraphic {
    private AlphaComposite _composite = this.createComposite(1.0f);

    public VariableAlphaImageGraphic(Component component, BufferedImage bufferedImage) {
        this(component, bufferedImage, 1.0f);
    }

    public VariableAlphaImageGraphic(Component component, BufferedImage bufferedImage, float f) {
        super(component, bufferedImage);
    }

    public void setAlpha(float f) {
        if (f != this._composite.getAlpha()) {
            this._composite = this.createComposite(f);
            this.setBoundsDirty();
            this.autorepaint();
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(this._composite);
            super.paint(graphics2D);
            graphics2D.setComposite(composite);
        }
    }

    private AlphaComposite createComposite(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("0 <= alpha <= 1 is required: " + f);
        }
        return AlphaComposite.getInstance(3, f);
    }
}

