/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.util;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;

public class QuadBezierSpline
extends QuadCurve2D.Double {
    public QuadBezierSpline(Point point, Point point2, Point point3) {
        super(point.x, point.y, point2.x, point2.y, point3.x, point3.y);
    }

    public Point2D evaluate(double d, Point2D point2D) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("t is out of range: " + d);
        }
        double d2 = this.getX1() * d * d + this.getCtrlX() * 2.0 * d * (1.0 - d) + this.getX2() * (1.0 - d) * (1.0 - d);
        double d3 = this.getY1() * d * d + this.getCtrlY() * 2.0 * d * (1.0 - d) + this.getY2() * (1.0 - d) * (1.0 - d);
        if (point2D == null) {
            point2D = new Point2D.Double();
        }
        point2D.setLocation(d2, d3);
        return point2D;
    }
}

