/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.faraday.model.BarMagnet;

public class Turbine
extends BarMagnet
implements ModelElement {
    private double _speed = 0.0;
    private double _maxRPM;
    private double _maxDelta;

    public Turbine() {
        this.setMaxRPM(100.0);
    }

    public void setSpeed(double d) {
        assert (d >= -1.0 && d <= 1.0);
        this._speed = d;
        this.notifyObservers();
    }

    public double getSpeed() {
        return this._speed;
    }

    public void setMaxRPM(double d) {
        this._maxRPM = d;
        double d2 = 25.0;
        double d3 = 60.0 * d2;
        this._maxDelta = Math.PI * 2 * (d / d3);
    }

    public double getRPM() {
        return Math.abs(this._speed * this._maxRPM);
    }

    public void stepInTime(double d) {
        if (this._speed != 0.0) {
            double d2 = d * this._speed * this._maxDelta;
            double d3 = this.getDirection() + d2;
            int n = d3 < 0.0 ? -1 : 1;
            d3 = (double)n * (Math.abs(d3) % (Math.PI * 2));
            this.setDirection(d3);
        }
    }
}

