/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.faraday.model.AbstractMagnet;
import edu.colorado.phet.faraday.model.FaradayObservable;
import java.awt.geom.Point2D;

public class FieldMeter
extends FaradayObservable
implements SimpleObserver {
    private AbstractMagnet _magnetModel;
    private Vector2D _fieldVector;
    private Point2D _location;

    public FieldMeter(AbstractMagnet abstractMagnet) {
        assert (abstractMagnet != null);
        this._magnetModel = abstractMagnet;
        this._magnetModel.addObserver(this);
        this._fieldVector = new Vector2D();
        this._location = new Point2D.Double();
        this.update();
    }

    public void getStrength(Vector2D vector2D) {
        assert (vector2D != null);
        vector2D.setComponents(this._fieldVector.getX(), this._fieldVector.getY());
    }

    public void notifySelf() {
        this.update();
    }

    public void update() {
        if (this.isEnabled()) {
            this.getLocation(this._location);
            this._magnetModel.getBField(this._location, this._fieldVector);
            this.notifyObservers();
        }
    }
}

