/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.faraday.model.ElectronPathDescriptor;
import edu.colorado.phet.faraday.model.FaradayObservable;
import edu.colorado.phet.faraday.util.QuadBezierSpline;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Electron
extends FaradayObservable
implements ModelElement {
    private ArrayList<ElectronPathDescriptor> _path = null;
    private int _pathIndex = 0;
    private double _pathPosition = 1.0;
    private double _speed = 0.0;
    private Point2D _point = new Point2D.Double();
    private double _speedScale = 1.0;

    public void setPath(ArrayList<ElectronPathDescriptor> arrayList) {
        assert (arrayList != null);
        assert (arrayList.size() > 0);
        this._path = arrayList;
        this._pathIndex = 0;
        this._pathPosition = 1.0;
    }

    public ElectronPathDescriptor getPathDescriptor() {
        return this._path.get(this._pathIndex);
    }

    public void setPositionAlongPath(int n, double d) {
        assert (d >= 0.0 && d <= 1.0);
        assert (n >= 0 && n < this._path.size());
        this._pathIndex = n;
        this._pathPosition = d;
        ElectronPathDescriptor electronPathDescriptor = this._path.get(this._pathIndex);
        QuadBezierSpline quadBezierSpline = electronPathDescriptor.getCurve();
        quadBezierSpline.evaluate(this._pathPosition, this._point);
        super.setLocation(this._point);
    }

    public void setSpeed(double d) {
        assert (d >= -1.0 && d <= 1.0);
        this._speed = d;
    }

    public void setSpeedScale(double d) {
        this._speedScale = d;
    }

    @Override
    public void stepInTime(double d) {
        if (this.isEnabled() && this._speed != 0.0 && this._path != null) {
            double d2 = this._path.get(this._pathIndex).getPathScale();
            double d3 = d * 0.15 * this._speed * this._speedScale * d2;
            this._pathPosition -= d3;
            if (this._pathPosition <= 0.0 || this._pathPosition >= 1.0) {
                this.switchCurves();
            }
            ElectronPathDescriptor electronPathDescriptor = this._path.get(this._pathIndex);
            QuadBezierSpline quadBezierSpline = electronPathDescriptor.getCurve();
            quadBezierSpline.evaluate(this._pathPosition, this._point);
            super.setLocation(this._point);
        }
    }

    private void switchCurves() {
        double d = this._path.get(this._pathIndex).getPathScale();
        if (this._pathPosition <= 0.0) {
            ++this._pathIndex;
            if (this._pathIndex > this._path.size() - 1) {
                this._pathIndex = 0;
            }
            double d2 = this._path.get(this._pathIndex).getPathScale();
            double d3 = Math.abs(this._pathPosition * d2 / d);
            this._pathPosition = 1.0 - d3;
            if (this._pathPosition < 0.0) {
                this.switchCurves();
            }
        } else if (this._pathPosition >= 1.0) {
            --this._pathIndex;
            if (this._pathIndex < 0) {
                this._pathIndex = this._path.size() - 1;
            }
            double d4 = this._path.get(this._pathIndex).getPathScale();
            double d5 = Math.abs((1.0 - this._pathPosition) * d4 / d);
            this._pathPosition = 0.0 + d5;
            if (this._pathPosition > 1.0) {
                this.switchCurves();
            }
        }
    }
}

