/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.faraday.model.FaradayObservable;

public abstract class AbstractCoil
extends FaradayObservable {
    private int _numberOfLoops;
    private double _radius;
    private double _wireWidth;
    private double _loopSpacing;
    private double _currentAmplitude;

    public AbstractCoil() {
        this(1, 10.0, 16.0, 25.0);
    }

    public AbstractCoil(int n, double d, double d2, double d3) {
        this._numberOfLoops = n;
        this._radius = d;
        this._wireWidth = d2;
        this._loopSpacing = d3;
        this._currentAmplitude = 0.0;
    }

    public void setNumberOfLoops(int n) {
        assert (n > 0);
        if (n != this._numberOfLoops) {
            this._numberOfLoops = n;
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public int getNumberOfLoops() {
        return this._numberOfLoops;
    }

    public void setRadius(double d) {
        assert (d > 0.0);
        if (d != this._radius) {
            this._radius = d;
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public double getRadius() {
        return this._radius;
    }

    public void setLoopArea(double d) {
        double d2 = Math.sqrt(d / Math.PI);
        this.setRadius(d2);
    }

    public double getLoopArea() {
        return Math.PI * this._radius * this._radius;
    }

    public double getWireWidth() {
        return this._wireWidth;
    }

    public void setLoopSpacing(double d) {
        assert (d > 0.0);
        if (d != this._loopSpacing) {
            this._loopSpacing = d;
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public double getLoopSpacing() {
        return this._loopSpacing;
    }

    protected void setCurrentAmplitude(double d) {
        if (d < -1.0 || d > 1.0) {
            throw new IllegalArgumentException("currentAmplitude is out of range: " + d);
        }
        if (d != this._currentAmplitude) {
            this._currentAmplitude = d;
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public double getCurrentAmplitude() {
        return this._currentAmplitude;
    }
}

