/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.panel;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.panel.FaradayPanel;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.model.Turbine;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TurbinePanel
extends FaradayPanel {
    private Turbine _turbineModel;
    private Compass _compassModel;
    private FieldMeter _fieldMeterModel;
    private BFieldOutsideGraphic _bFieldOutsideGraphic;
    private LinearValueControl _strengthControl;
    private JCheckBox _bFieldCheckBox;
    private JCheckBox _fieldMeterCheckBox;
    private JCheckBox _compassCheckBox;
    private EventListener _listener;

    public TurbinePanel(Turbine turbine, Compass compass, FieldMeter fieldMeter, BFieldOutsideGraphic bFieldOutsideGraphic) {
        assert (turbine != null);
        assert (compass != null);
        assert (fieldMeter != null);
        assert (bFieldOutsideGraphic != null);
        this._turbineModel = turbine;
        this._compassModel = compass;
        this._fieldMeterModel = fieldMeter;
        this._bFieldOutsideGraphic = bFieldOutsideGraphic;
        Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, FaradayStrings.TITLE_TURBINE_PANEL);
        titledBorder.setTitleFont(this.getTitleFont());
        this.setBorder(titledBorder);
        int n = 100;
        int n2 = 0;
        this._strengthControl = new LinearValueControl(n2, n, FaradayStrings.LABEL_STRENGTH, "0", "%");
        this._strengthControl.setValue(n2);
        this._strengthControl.setMajorTickSpacing(50.0);
        this._strengthControl.setMinorTickSpacing(10.0);
        this._strengthControl.setTextFieldEditable(true);
        this._strengthControl.setTextFieldColumns(3);
        this._strengthControl.setUpDownArrowDelta(1.0);
        this._strengthControl.setBorder(BorderFactory.createEtchedBorder());
        this._bFieldCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_B_FIELD);
        this._fieldMeterCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_FIELD_METER);
        this._compassCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_COMPASS);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        n2 = 0;
        easyGridBagLayout.addFilledComponent(this._strengthControl, n2++, 0, 2);
        easyGridBagLayout.addComponent(this._bFieldCheckBox, n2++, 0);
        easyGridBagLayout.addComponent(this._compassCheckBox, n2++, 0);
        easyGridBagLayout.addComponent(this._fieldMeterCheckBox, n2++, 0);
        this._listener = new EventListener();
        this._strengthControl.addChangeListener(this._listener);
        this._bFieldCheckBox.addActionListener(this._listener);
        this._fieldMeterCheckBox.addActionListener(this._listener);
        this._compassCheckBox.addActionListener(this._listener);
        this.update();
    }

    public void update() {
        this._strengthControl.setValue((int)(100.0 * this._turbineModel.getStrength() / this._turbineModel.getMaxStrength()));
        this._bFieldCheckBox.setSelected(this._bFieldOutsideGraphic.isVisible());
        this._fieldMeterCheckBox.setSelected(this._fieldMeterModel.isEnabled());
        this._compassCheckBox.setSelected(this._compassModel.isEnabled());
    }

    private class EventListener
    implements ActionListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == TurbinePanel.this._bFieldCheckBox) {
                TurbinePanel.this._bFieldOutsideGraphic.setVisible(TurbinePanel.this._bFieldCheckBox.isSelected());
            } else if (actionEvent.getSource() == TurbinePanel.this._fieldMeterCheckBox) {
                TurbinePanel.this._fieldMeterModel.setEnabled(TurbinePanel.this._fieldMeterCheckBox.isSelected());
            } else if (actionEvent.getSource() == TurbinePanel.this._compassCheckBox) {
                TurbinePanel.this._compassModel.setEnabled(TurbinePanel.this._compassCheckBox.isSelected());
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() != TurbinePanel.this._strengthControl) {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
            double d = Math.floor(TurbinePanel.this._strengthControl.getValue());
            double d2 = d / 100.0 * 300.0;
            TurbinePanel.this._turbineModel.setStrength(d2);
            TurbinePanel.this._strengthControl.removeChangeListener(TurbinePanel.this._listener);
            TurbinePanel.this._strengthControl.setValue(d);
            TurbinePanel.this._strengthControl.addChangeListener(TurbinePanel.this._listener);
        }
    }
}

