/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.panel;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.panel.FaradayPanel;
import edu.colorado.phet.faraday.model.BarMagnet;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.view.BFieldInsideGraphic;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import edu.colorado.phet.faraday.view.EarthGraphic;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BarMagnetPanel
extends FaradayPanel {
    private BarMagnet _barMagnetModel;
    private Compass _compassModel;
    private FieldMeter _fieldMeterModel;
    private BFieldInsideGraphic _bFieldInsideGraphic;
    private BFieldOutsideGraphic _bFieldOutsideGraphic;
    private EarthGraphic _earthGraphic;
    private JButton _flipPolarityButton;
    private LinearValueControl _strengthControl;
    private JCheckBox _seeInsideCheckBox;
    private JCheckBox _bFieldCheckBox;
    private JCheckBox _fieldMeterCheckBox;
    private JCheckBox _compassCheckBox;
    private JCheckBox _earthCheckBox;
    private EventListener _listener;

    public BarMagnetPanel(BarMagnet barMagnet, Compass compass, FieldMeter fieldMeter, BFieldInsideGraphic bFieldInsideGraphic, BFieldOutsideGraphic bFieldOutsideGraphic, EarthGraphic earthGraphic) {
        assert (barMagnet != null);
        assert (compass != null);
        assert (fieldMeter != null);
        assert (bFieldOutsideGraphic != null);
        this._barMagnetModel = barMagnet;
        this._compassModel = compass;
        this._fieldMeterModel = fieldMeter;
        this._bFieldInsideGraphic = bFieldInsideGraphic;
        this._bFieldOutsideGraphic = bFieldOutsideGraphic;
        this._earthGraphic = earthGraphic;
        Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, FaradayStrings.TITLE_BAR_MAGNET_PANEL);
        titledBorder.setTitleFont(this.getTitleFont());
        this.setBorder(titledBorder);
        int n = 100;
        int n2 = 0;
        this._strengthControl = new LinearValueControl(n2, n, FaradayStrings.LABEL_STRENGTH, "0", "%");
        this._strengthControl.setValue(n2);
        this._strengthControl.setMajorTickSpacing(50.0);
        this._strengthControl.setMinorTickSpacing(10.0);
        this._strengthControl.setTextFieldEditable(true);
        this._strengthControl.setTextFieldColumns(3);
        this._strengthControl.setUpDownArrowDelta(1.0);
        this._strengthControl.setBorder(BorderFactory.createEtchedBorder());
        this._flipPolarityButton = new JButton(FaradayStrings.BUTTON_FLIP_POLARITY);
        this._seeInsideCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SEE_INSIDE);
        this._bFieldCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_B_FIELD);
        this._fieldMeterCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_FIELD_METER);
        this._compassCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_COMPASS);
        this._earthCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_EARTH);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        n2 = 0;
        easyGridBagLayout.addFilledComponent(this._strengthControl, n2++, 0, 2);
        easyGridBagLayout.addComponent(this._flipPolarityButton, n2++, 0);
        easyGridBagLayout.addComponent(this._seeInsideCheckBox, n2++, 0);
        easyGridBagLayout.addComponent(this._bFieldCheckBox, n2++, 0);
        easyGridBagLayout.addComponent(this._compassCheckBox, n2++, 0);
        easyGridBagLayout.addComponent(this._fieldMeterCheckBox, n2++, 0);
        if (earthGraphic != null) {
            easyGridBagLayout.addComponent(this._earthCheckBox, n2++, 0);
        }
        this._listener = new EventListener();
        this._flipPolarityButton.addActionListener(this._listener);
        this._strengthControl.addChangeListener(this._listener);
        this._bFieldCheckBox.addActionListener(this._listener);
        this._seeInsideCheckBox.addActionListener(this._listener);
        this._fieldMeterCheckBox.addActionListener(this._listener);
        this._compassCheckBox.addActionListener(this._listener);
        this._earthCheckBox.addActionListener(this._listener);
        this.update();
    }

    public void update() {
        this._strengthControl.setValue((int)(100.0 * this._barMagnetModel.getStrength() / 300.0));
        if (this._bFieldInsideGraphic != null) {
            this._seeInsideCheckBox.setSelected(this._bFieldInsideGraphic.isVisible());
        }
        this._bFieldCheckBox.setSelected(this._bFieldOutsideGraphic.isVisible());
        this._fieldMeterCheckBox.setSelected(this._fieldMeterModel.isEnabled());
        this._compassCheckBox.setSelected(this._compassModel.isEnabled());
        if (this._earthGraphic != null) {
            this._earthCheckBox.setSelected(this._earthGraphic.isVisible());
        }
    }

    public void setSeeInsideControlVisible(boolean bl) {
        this._seeInsideCheckBox.setVisible(bl);
    }

    public void setShowEarthControlVisible(boolean bl) {
        this._earthCheckBox.setVisible(bl);
    }

    private class EventListener
    implements ActionListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BarMagnetPanel.this._flipPolarityButton) {
                BarMagnetPanel.this._barMagnetModel.flipPolarity();
                BarMagnetPanel.this._compassModel.startMovingNow();
            } else if (actionEvent.getSource() == BarMagnetPanel.this._bFieldCheckBox) {
                BarMagnetPanel.this._bFieldOutsideGraphic.setVisible(BarMagnetPanel.this._bFieldCheckBox.isSelected());
            } else if (actionEvent.getSource() == BarMagnetPanel.this._seeInsideCheckBox) {
                BarMagnetPanel.this._bFieldInsideGraphic.setVisible(BarMagnetPanel.this._seeInsideCheckBox.isSelected());
            } else if (actionEvent.getSource() == BarMagnetPanel.this._fieldMeterCheckBox) {
                BarMagnetPanel.this._fieldMeterModel.setEnabled(BarMagnetPanel.this._fieldMeterCheckBox.isSelected());
            } else if (actionEvent.getSource() == BarMagnetPanel.this._compassCheckBox) {
                BarMagnetPanel.this._compassModel.setEnabled(BarMagnetPanel.this._compassCheckBox.isSelected());
            } else if (actionEvent.getSource() == BarMagnetPanel.this._earthCheckBox) {
                BarMagnetPanel.this._earthGraphic.setVisible(BarMagnetPanel.this._earthCheckBox.isSelected());
                if (BarMagnetPanel.this._earthCheckBox.isSelected()) {
                    BarMagnetPanel.this._barMagnetModel.setDirection(BarMagnetPanel.this._barMagnetModel.getDirection() + 1.5707963267948966);
                } else {
                    BarMagnetPanel.this._barMagnetModel.setDirection(BarMagnetPanel.this._barMagnetModel.getDirection() - 1.5707963267948966);
                }
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() != BarMagnetPanel.this._strengthControl) {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
            double d = Math.floor(BarMagnetPanel.this._strengthControl.getValue());
            double d2 = d / 100.0 * 300.0;
            BarMagnetPanel.this._barMagnetModel.setStrength(d2);
            BarMagnetPanel.this._strengthControl.removeChangeListener(BarMagnetPanel.this._listener);
            BarMagnetPanel.this._strengthControl.setValue(d);
            BarMagnetPanel.this._strengthControl.addChangeListener(BarMagnetPanel.this._listener);
        }
    }
}

