/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util.logging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingUtils {
    private static Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static Set<String> fullLoggingPackages = new HashSet<String>();
    private static Handler handler = new ConsoleHandler();

    public static synchronized void enableAllLogging(String string) {
        fullLoggingPackages.add(string);
        for (String string2 : loggers.keySet()) {
            if (!string2.startsWith(string)) continue;
            LoggingUtils.enableLogging(loggers.get(string2));
        }
    }

    public static synchronized Logger getLogger(String string) {
        if (loggers.containsKey(string)) {
            return loggers.get(string);
        }
        Logger logger = Logger.getAnonymousLogger();
        loggers.put(string, logger);
        if (LoggingUtils.hasAllLevelsEnabled(string)) {
            LoggingUtils.enableLogging(logger);
        }
        return logger;
    }

    public static synchronized boolean hasAllLevelsEnabled(String string) {
        for (String string2 : fullLoggingPackages) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static void enableLogging(Logger logger) {
        try {
            if (logger.getLevel() == null) {
                logger.setLevel(Level.ALL);
            }
            for (Handler handler : logger.getHandlers()) {
                if (handler != LoggingUtils.handler) continue;
                return;
            }
            logger.addHandler(handler);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static {
        try {
            handler.setLevel(Level.ALL);
            handler.setFilter(new Filter(){

                public boolean isLoggable(LogRecord logRecord) {
                    return logRecord.getLevel() == Level.FINE || logRecord.getLevel() == Level.FINER || logRecord.getLevel() == Level.FINEST;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

