/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.Photon;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.photonabsorption.view.MoleculeNode;
import edu.colorado.phet.common.photonabsorption.view.PhotonEmitterNode;
import edu.colorado.phet.common.photonabsorption.view.PhotonNode;
import edu.colorado.phet.common.photonabsorption.view.VerticalRodNode;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.greenhouse.GreenhouseDefaults;
import edu.colorado.phet.greenhouse.view.DualEmissionFrequencyControlPanel;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class PhotonAbsorptionCanvas
extends PhetPCanvas {
    private final ModelViewTransform2D mvt;
    PNode myWorldNode;
    private final PNode moleculeLayer;
    private final PNode photonLayer;
    private final PNode photonEmitterLayer;
    private final HashMap<Photon, PhotonNode> photonMap = new HashMap();
    private final HashMap<Molecule, MoleculeNode> moleculeMap = new HashMap();

    public PhotonAbsorptionCanvas(PhotonAbsorptionModel photonAbsorptionModel, boolean bl) {
        this.setWorldTransformStrategy(new PhetPCanvas.CenteringBoxStrategy(this, GreenhouseDefaults.INTERMEDIATE_RENDERING_SIZE));
        double d = bl ? 0.23 : 0.18;
        this.mvt = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point((int)Math.round(GreenhouseDefaults.INTERMEDIATE_RENDERING_SIZE.width * 0.65), (int)Math.round(GreenhouseDefaults.INTERMEDIATE_RENDERING_SIZE.height * 0.5)), d, true);
        this.setBackground(Color.BLACK);
        photonAbsorptionModel.addListener(new PhotonAbsorptionModel.Adapter(){

            public void photonRemoved(Photon photon) {
                if (PhotonAbsorptionCanvas.this.photonLayer.removeChild((PNode)PhotonAbsorptionCanvas.this.photonMap.get(photon)) == null) {
                    System.out.println(this.getClass().getName() + " - Error: PhotonNode not found for photon.");
                }
                PhotonAbsorptionCanvas.this.photonMap.remove(photon);
            }

            public void photonAdded(Photon photon) {
                PhotonNode photonNode = new PhotonNode(photon, PhotonAbsorptionCanvas.this.mvt);
                PhotonAbsorptionCanvas.this.photonLayer.addChild(photonNode);
                PhotonAbsorptionCanvas.this.photonMap.put(photon, photonNode);
            }

            public void moleculeRemoved(Molecule molecule) {
                if (PhotonAbsorptionCanvas.this.moleculeLayer.removeChild((PNode)PhotonAbsorptionCanvas.this.moleculeMap.get(molecule)) == null) {
                    System.out.println(this.getClass().getName() + " - Error: MoleculeNode not found for molecule.");
                }
                PhotonAbsorptionCanvas.this.moleculeMap.remove(molecule);
            }

            public void moleculeAdded(Molecule molecule) {
                PhotonAbsorptionCanvas.this.addMolecule(molecule);
            }
        });
        this.myWorldNode = new PNode();
        this.addWorldChild(this.myWorldNode);
        this.moleculeLayer = new PNode();
        this.myWorldNode.addChild(this.moleculeLayer);
        this.photonLayer = new PNode();
        this.myWorldNode.addChild(this.photonLayer);
        this.photonEmitterLayer = new PNode();
        this.myWorldNode.addChild(this.photonEmitterLayer);
        PhetPPath phetPPath = new PhetPPath(this.mvt.createTransformedShape(photonAbsorptionModel.getContainmentAreaRect()), (Stroke)new BasicStroke(6.0f), (Paint)Color.LIGHT_GRAY);
        this.moleculeLayer.addChild(phetPPath);
        PhotonEmitterNode photonEmitterNode = new PhotonEmitterNode(300.0, this.mvt, photonAbsorptionModel);
        photonEmitterNode.setOffset(this.mvt.modelToViewDouble(photonAbsorptionModel.getPhotonEmissionLocation()));
        DualEmissionFrequencyControlPanel dualEmissionFrequencyControlPanel = new DualEmissionFrequencyControlPanel(photonAbsorptionModel);
        dualEmissionFrequencyControlPanel.setOffset(photonEmitterNode.getFullBoundsReference().getCenterX() - dualEmissionFrequencyControlPanel.getFullBoundsReference().width / 2.0, photonEmitterNode.getFullBoundsReference().getMaxY() + 50.0);
        VerticalRodNode verticalRodNode = new VerticalRodNode(30.0, Math.abs(photonEmitterNode.getFullBoundsReference().getCenterY() - dualEmissionFrequencyControlPanel.getFullBoundsReference().getCenterY()), Color.LIGHT_GRAY);
        verticalRodNode.setOffset(photonEmitterNode.getFullBoundsReference().getCenterX() - verticalRodNode.getFullBoundsReference().width / 2.0, photonEmitterNode.getFullBoundsReference().getCenterY());
        this.photonEmitterLayer.addChild(verticalRodNode);
        this.photonEmitterLayer.addChild(photonEmitterNode);
        this.photonEmitterLayer.addChild(dualEmissionFrequencyControlPanel);
        for (Molecule molecule : photonAbsorptionModel.getMolecules()) {
            this.addMolecule(molecule);
        }
        this.updateLayout();
    }

    private void addMolecule(Molecule molecule) {
        MoleculeNode moleculeNode = new MoleculeNode(molecule, this.mvt);
        this.moleculeLayer.addChild(moleculeNode);
        this.moleculeMap.put(molecule, moleculeNode);
    }
}

