/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.photonabsorption.PhotonAbsorptionResources;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DualEmissionFrequencyControlPanel
extends PNode {
    private static final Font LABEL_FONT = new PhetFont(24);
    private final PhotonAbsorptionModel model;
    private final JRadioButton infraredPhotonRadioButton;
    private final JRadioButton visiblePhotonRadioButton;

    public DualEmissionFrequencyControlPanel(final PhotonAbsorptionModel photonAbsorptionModel) {
        this.model = photonAbsorptionModel;
        photonAbsorptionModel.addListener(new PhotonAbsorptionModel.Adapter(){

            public void emittedPhotonWavelengthChanged() {
                DualEmissionFrequencyControlPanel.this.updateFrequencySelectButtons();
            }
        });
        this.infraredPhotonRadioButton = new JRadioButton(GreenhouseResources.getString("PhotonEmitterNode.Infrared"));
        this.infraredPhotonRadioButton.setFont(LABEL_FONT);
        this.infraredPhotonRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photonAbsorptionModel.setEmittedPhotonWavelength(8.5E-7);
            }
        });
        class BorderLayoutPanel
        extends JPanel {
            public BorderLayoutPanel(JComponent jComponent, JComponent jComponent2) {
                this.setLayout(new BorderLayout());
                this.add((Component)jComponent, "West");
                this.add((Component)jComponent2, "East");
            }
        }
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel(this.infraredPhotonRadioButton, new JLabel(new ImageIcon(PhotonAbsorptionResources.getImage("photon-660.png"))));
        this.visiblePhotonRadioButton = new JRadioButton(GreenhouseResources.getString("PhotonEmitterNode.Visible"));
        this.visiblePhotonRadioButton.setFont(LABEL_FONT);
        this.visiblePhotonRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                photonAbsorptionModel.setEmittedPhotonWavelength(5.8E-7);
            }
        });
        BorderLayoutPanel borderLayoutPanel2 = new BorderLayoutPanel(this.visiblePhotonRadioButton, new JLabel(new ImageIcon(PhotonAbsorptionResources.getImage("thin2.png"))));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.infraredPhotonRadioButton);
        buttonGroup.add(this.visiblePhotonRadioButton);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillHorizontal();
        verticalLayoutPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        verticalLayoutPanel.add(borderLayoutPanel);
        verticalLayoutPanel.add(borderLayoutPanel2);
        PSwing pSwing = new PSwing(verticalLayoutPanel);
        this.addChild(pSwing);
        this.updateFrequencySelectButtons();
    }

    private void updateFrequencySelectButtons() {
        if (this.model.getEmittedPhotonWavelength() == 8.5E-7) {
            if (!this.infraredPhotonRadioButton.isSelected()) {
                this.infraredPhotonRadioButton.setSelected(true);
            }
        } else if (!this.visiblePhotonRadioButton.isSelected()) {
            this.visiblePhotonRadioButton.setSelected(true);
        }
    }
}

