/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.photonabsorption.model.PhotonEmitter;
import edu.colorado.phet.greenhouse.model.Photon;
import edu.colorado.phet.greenhouse.model.PhotonAbsorber;
import java.util.HashSet;

public class PhotonFactory
implements PhotonEmitter,
PhotonAbsorber {
    private HashSet emitterListeners = new HashSet();
    private HashSet absorberListeners = new HashSet();
    private Photon emittedPhoton;

    public void addListener(PhotonEmitter.Listener listener) {
        this.emitterListeners.add(listener);
    }

    public void emitPhoton(Photon photon) {
        this.emittedPhoton = photon;
        this.emitPhoton();
    }

    public Photon emitPhoton() {
        for (PhotonEmitter.Listener listener : this.emitterListeners) {
            listener.photonEmitted(this.emittedPhoton);
        }
        return null;
    }

    public void addListener(PhotonAbsorber.Listener listener) {
        this.absorberListeners.add(listener);
    }

    public void absorbPhoton(Photon photon) {
        for (PhotonAbsorber.Listener listener : this.absorberListeners) {
            listener.photonAbsorbed(photon);
        }
    }
}

