/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.photonabsorption.model.PhotonEmitter;
import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.model.Disk;
import java.awt.geom.Point2D;

public class Photon
extends Disk {
    private double wavelength;
    private double energy;
    private PhotonEmitter source;

    public Photon(double d, PhotonEmitter photonEmitter) {
        super(new Point2D.Double(), GreenhouseConfig.photonRadius);
        this.wavelength = d;
        this.source = photonEmitter;
        this.energy = 1.987923788998E-25 / d;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void setDirection(double d) {
        super.setVelocity((float)(0.01 * Math.cos(d)), (float)(0.01 * Math.sin(d)));
    }

    public double getMass() {
        return 1.0;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getWavelength() {
        return this.wavelength;
    }
}

