/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.photonabsorption.model.PhotonEmitter;
import edu.colorado.phet.greenhouse.model.Atmosphere;
import edu.colorado.phet.greenhouse.model.Cloud;
import edu.colorado.phet.greenhouse.model.Earth;
import edu.colorado.phet.greenhouse.model.GlassPane;
import edu.colorado.phet.greenhouse.model.Photon;
import edu.colorado.phet.greenhouse.model.PhotonAbsorber;
import edu.colorado.phet.greenhouse.model.PhotonCloudCollisionModel;
import edu.colorado.phet.greenhouse.model.PhotonEarthCollisionModel;
import edu.colorado.phet.greenhouse.model.PhotonGlassPaneCollisionModel;
import edu.colorado.phet.greenhouse.model.Star;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreenhouseModel
extends BaseModel
implements PhotonEmitter.Listener<Photon>,
PhotonAbsorber.Listener {
    private Star sun;
    private Earth earth;
    private Atmosphere atmosphere;
    private ArrayList photons = new ArrayList();
    private ArrayList clouds = new ArrayList();
    private ArrayList glassPanes = new ArrayList();
    private Rectangle2D.Double bounds;

    public GreenhouseModel(Rectangle2D.Double double_) {
        this.bounds = double_;
    }

    public Rectangle2D.Double getBounds() {
        return this.bounds;
    }

    public ArrayList getPhotons() {
        return this.photons;
    }

    @Override
    public void update(ClockEvent clockEvent) {
        super.update(clockEvent);
        for (int i = this.photons.size() - 1; i >= 0; --i) {
            Object object;
            int n;
            Photon photon = (Photon)this.photons.get(i);
            PhotonEarthCollisionModel.handle(photon, this.earth);
            for (n = 0; n < this.clouds.size(); ++n) {
                object = (Cloud)this.clouds.get(n);
                PhotonCloudCollisionModel.handle(photon, (Cloud)object);
            }
            for (n = 0; n < this.glassPanes.size(); ++n) {
                object = (GlassPane)this.glassPanes.get(n);
                PhotonGlassPaneCollisionModel.handle(photon, (GlassPane)object, clockEvent.getClock());
            }
            this.atmosphere.interactWithPhoton(photon);
        }
    }

    @Override
    public void addModelElement(ModelElement modelElement) {
        super.addModelElement(modelElement);
    }

    @Override
    public void removeModelElement(ModelElement modelElement) {
        super.removeModelElement(modelElement);
    }

    public void setSun(Star star) {
        super.addModelElement(star);
        star.addListener(this);
        this.sun = star;
    }

    public void setEarth(Earth earth) {
        super.addModelElement(earth);
        earth.addPhotonAbsorberListener(this);
        earth.addPhotonEmitterListener(this);
        this.earth = earth;
    }

    public void setAtmosphere(Atmosphere atmosphere) {
        super.addModelElement(atmosphere);
        this.atmosphere = atmosphere;
    }

    private void addPhoton(Photon photon) {
        super.addModelElement(photon);
        this.photons.add(photon);
    }

    @Override
    public void photonEmitted(Photon photon) {
        this.addPhoton(photon);
    }

    @Override
    public void photonAbsorbed(Photon photon) {
        super.removeModelElement(photon);
        this.photons.remove(photon);
    }

    public void setSunPhotonProductionRate(double d) {
        this.sun.setProductionRate(d);
    }

    public void setEarthEmissivity(double d) {
        this.earth.setEmissivity(d);
    }

    public void addCloud(Cloud cloud) {
        this.clouds.add(cloud);
    }

    public void removeCloud(Cloud cloud) {
        this.clouds.remove(cloud);
    }

    public void addGlassPane(GlassPane glassPane) {
        this.glassPanes.add(glassPane);
    }

    public void removeGlassPane(GlassPane glassPane) {
        this.glassPanes.remove(glassPane);
    }

    public void setGreenhouseGasConcentration(double d) {
        this.atmosphere.setGreenhouseGasConcentration(d);
    }

    public void removePhoton(Photon photon) {
        this.photons.remove(photon);
    }
}

