/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import java.awt.geom.Point2D;
import java.util.Observable;

public abstract class Body
extends Observable
implements ModelElement {
    private double omega;
    private double mass;
    private Point2D.Double location = new Point2D.Double();
    private Vector2D velocity = new Vector2D();
    private Vector2D acceleration = new Vector2D();
    private Body lastColidedBody = null;

    protected Body() {
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public void setLocation(double d, double d2) {
        this.location.setLocation(d, d2);
    }

    public double getOmega() {
        return this.omega;
    }

    public void setOmega(double d) {
        this.omega = d;
    }

    public Vector2D getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double d, double d2) {
        this.velocity.setX(d);
        this.velocity.setY(d2);
    }

    public double getMass() {
        return this.mass;
    }

    public void stepInTime(double d) {
        double d2 = this.location.getX() + d * this.velocity.getX() + d * d * this.acceleration.getX() / 2.0;
        double d3 = this.location.getY() + d * this.velocity.getY() + d * d * this.acceleration.getY() / 2.0;
        this.setLocation(d2, d3);
        this.setChanged();
        this.notifyObservers();
    }

    public abstract double getMomentOfInertia();
}

