/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.photonabsorption.model.PhotonEmitter;
import edu.colorado.phet.greenhouse.model.Photon;
import java.util.HashSet;
import java.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPhotonEmitter
extends Observable
implements ModelElement,
PhotonEmitter<Photon> {
    private double productionRate;
    private double timeSincePhotonsProduced;
    private HashSet listeners = new HashSet();

    public void addListener(PhotonEmitter.Listener listener) {
        this.listeners.add(listener);
    }

    public void setProductionRate(double d) {
        this.timeSincePhotonsProduced = 0.0;
        this.productionRate = d;
    }

    @Override
    public void stepInTime(double d) {
        this.timeSincePhotonsProduced += d;
        int n = (int)(this.productionRate * this.timeSincePhotonsProduced);
        for (int i = 0; i < n; ++i) {
            Photon photon = (Photon)this.emitPhoton();
            this.notifyListeners(photon);
            this.timeSincePhotonsProduced = 0.0;
        }
    }

    protected void notifyListeners(Photon photon) {
        for (PhotonEmitter.Listener listener : this.listeners) {
            listener.photonEmitted(photon);
        }
    }
}

