/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse.controlpanel;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.MoleculeID;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.colorado.phet.common.photonabsorption.model.molecules.CH4;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.H2O;
import edu.colorado.phet.common.photonabsorption.model.molecules.N2;
import edu.colorado.phet.common.photonabsorption.model.molecules.O2;
import edu.colorado.phet.common.photonabsorption.view.MoleculeNode;
import edu.colorado.phet.common.photonabsorption.view.MoleculeSelectorPanelWithToolTip;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhotonAbsorptionControlPanel
extends ControlPanel {
    private static final Font LABEL_FONT = new PhetFont(14);
    private static final ModelViewTransform2D MVT = new ModelViewTransform2D((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point(0, 0), 1.0, true);
    private final PhotonAbsorptionModel model;
    private final HashMap<MoleculeID, LinearValueControl> moleculeToSliderMap = new HashMap();
    private final ArrayList<MoleculeSelectorPanelWithToolTip> gasSelectors = new ArrayList();

    public PhotonAbsorptionControlPanel(PiccoloModule piccoloModule, PhotonAbsorptionModel photonAbsorptionModel) {
        this.model = photonAbsorptionModel;
        photonAbsorptionModel.addListener(new PhotonAbsorptionModel.Adapter(){

            public void photonTargetChanged() {
                PhotonAbsorptionControlPanel.this.updateSliderEnabledState();
            }

            public void configurableAtmosphereCompositionChanged() {
                PhotonAbsorptionControlPanel.this.updateSliderPositions();
            }
        });
        int n = GreenhouseResources.getInt("int.minControlPanelWidth", 215);
        this.setMinimumWidth(n);
        PhetTitledPanel phetTitledPanel = new PhetTitledPanel(GreenhouseResources.getString("ControlPanel.AtmosphericGasesTitle"));
        phetTitledPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.addControlFullWidth(phetTitledPanel);
        this.gasSelectors.add(new MoleculeSelectorPanelWithToolTip(GreenhouseResources.getString("ControlPanel.CH4"), GreenhouseResources.getString("ControlPanel.Methane"), this.createMoleculeImage(new CH4(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_CH4_MOLECULE));
        this.gasSelectors.add(new MoleculeSelectorPanelWithToolTip(GreenhouseResources.getString("ControlPanel.CO2"), GreenhouseResources.getString("ControlPanel.CarbonDioxide"), this.createMoleculeImage(new CO2(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_CO2_MOLECULE));
        this.gasSelectors.add(new MoleculeSelectorPanelWithToolTip(GreenhouseResources.getString("ControlPanel.H2O"), GreenhouseResources.getString("ControlPanel.Water"), this.createMoleculeImage(new H2O(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_H2O_MOLECULE));
        this.gasSelectors.add(new MoleculeSelectorPanelWithToolTip(GreenhouseResources.getString("ControlPanel.N2"), GreenhouseResources.getString("ControlPanel.Nitrogen"), this.createMoleculeImage(new N2(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_N2_MOLECULE));
        this.gasSelectors.add(new MoleculeSelectorPanelWithToolTip(GreenhouseResources.getString("ControlPanel.O2"), GreenhouseResources.getString("ControlPanel.Oxygen"), this.createMoleculeImage(new O2(), 0.13), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.SINGLE_O2_MOLECULE));
        this.gasSelectors.add(new MoleculeSelectorPanelWithToolTip(GreenhouseResources.getString("ControlPanel.BuildAtmosphere"), null, BufferedImageUtils.multiScale(GreenhouseResources.getImage("earth.png"), 0.24), photonAbsorptionModel, PhotonAbsorptionModel.PhotonTarget.CONFIGURABLE_ATMOSPHERE));
        int n2 = 2;
        ButtonGroup buttonGroup = new ButtonGroup();
        for (MoleculeSelectorPanelWithToolTip moleculeSelectorPanelWithToolTip : this.gasSelectors) {
            phetTitledPanel.add((Component)this.createVerticalSpacingPanel(n2), gridBagConstraints);
            phetTitledPanel.add((Component)moleculeSelectorPanelWithToolTip, gridBagConstraints);
            buttonGroup.add(moleculeSelectorPanelWithToolTip.getRadioButton());
        }
        phetTitledPanel.add((Component)this.createVerticalSpacingPanel(n2), gridBagConstraints);
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        this.addSliderForMolecule(GreenhouseResources.getString("ControlPanel.CH4"), verticalLayoutPanel, MoleculeID.CH4);
        this.addSliderForMolecule(GreenhouseResources.getString("ControlPanel.CO2"), verticalLayoutPanel, MoleculeID.CO2);
        this.addSliderForMolecule(GreenhouseResources.getString("ControlPanel.H2O"), verticalLayoutPanel, MoleculeID.H2O);
        this.addSliderForMolecule(GreenhouseResources.getString("ControlPanel.N2"), verticalLayoutPanel, MoleculeID.N2);
        this.addSliderForMolecule(GreenhouseResources.getString("ControlPanel.O2"), verticalLayoutPanel, MoleculeID.O2);
        phetTitledPanel.add((Component)verticalLayoutPanel, gridBagConstraints);
        this.addControlFullWidth(this.createVerticalSpacingPanel(5));
        this.addResetAllButton(piccoloModule);
        this.updateSliderPositions();
        this.updateSliderEnabledState();
    }

    private void updateSliderPositions() {
        for (MoleculeID moleculeID : this.moleculeToSliderMap.keySet()) {
            this.moleculeToSliderMap.get((Object)moleculeID).setValue(this.model.getConfigurableAtmosphereGasLevel(moleculeID));
        }
    }

    private void updateSliderEnabledState() {
        boolean bl = this.model.getPhotonTarget() == PhotonAbsorptionModel.PhotonTarget.CONFIGURABLE_ATMOSPHERE;
        for (LinearValueControl linearValueControl : this.moleculeToSliderMap.values()) {
            linearValueControl.setEnabled(bl);
        }
    }

    private void addSliderForMolecule(String string, JPanel jPanel, final MoleculeID moleculeID) {
        int n = GreenhouseResources.getInt("int.minControlPanelWidth", 215) - 8;
        int n2 = 20;
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createHorizontalStrut(n2));
        final LinearValueControl linearValueControl = new LinearValueControl(0.0, this.model.getConfigurableAtmosphereMaxLevel(moleculeID), string, "###", GreenhouseResources.getString("ControlPanel.Molecules"));
        linearValueControl.setFont(LABEL_FONT);
        linearValueControl.setUpDownArrowDelta(1.0);
        linearValueControl.setTextFieldEditable(true);
        linearValueControl.setMajorTicksVisible(false);
        linearValueControl.setValue(this.model.getConfigurableAtmosphereGasLevel(moleculeID));
        linearValueControl.setSliderWidth(n - n2);
        linearValueControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = PhotonAbsorptionControlPanel.this.model.getConfigurableAtmosphereGasLevel(moleculeID);
                int n2 = (int)Math.round(linearValueControl.getValue());
                if (n2 != n) {
                    PhotonAbsorptionControlPanel.this.model.setConfigurableAtmosphereGasLevel(moleculeID, n2);
                }
            }
        });
        this.moleculeToSliderMap.put(moleculeID, linearValueControl);
        jPanel2.add(jPanel3);
        jPanel2.add(linearValueControl);
        jPanel.add(jPanel2);
    }

    private JPanel createVerticalSpacingPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }

    private BufferedImage createMoleculeImage(Molecule molecule, double d) {
        BufferedImage bufferedImage = new MoleculeNode(molecule, MVT).getImage();
        return BufferedImageUtils.multiScale(bufferedImage, d);
    }
}

