/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.greenhouse.BaseGreenhouseModule;
import edu.colorado.phet.greenhouse.GreenhouseControlPanel;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.model.Cloud;
import edu.colorado.phet.greenhouse.model.Earth;
import edu.colorado.phet.greenhouse.view.CloudGraphic;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JPanel;

public class GreenhouseModule
extends BaseGreenhouseModule {
    HashMap cloudsToGraphicMap = new HashMap();
    boolean cloudsEnabled = false;

    public GreenhouseModule() {
        super(GreenhouseResources.getString("ModuleTitle.GreenHouseModule"));
        this.createCloud(this.getEarth().getLocation().getX() + 1.0, this.getEarth().getLocation().getY() + Earth.radius + 7.5, 3.0, 0.3);
        this.createCloud(this.getEarth().getLocation().getX() - 5.0, this.getEarth().getLocation().getY() + Earth.radius + 5.0, 5.0, 0.5);
        this.createCloud(this.getEarth().getLocation().getX() + 5.5, this.getEarth().getLocation().getY() + Earth.radius + 5.8, 6.0, 0.4);
        JPanel jPanel = new JPanel();
        GreenhouseControlPanel greenhouseControlPanel = new GreenhouseControlPanel(this);
        jPanel.add(greenhouseControlPanel);
        this.setControlPanel(jPanel);
        this.getEarth().setJimmyArray(null);
    }

    public void reset() {
        super.reset();
        this.setToday();
        this.numCloudsEnabled(0);
        this.cloudsEnabled(false);
    }

    private void createCloud(double d, double d2, double d3, double d4) {
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        double_.setFrameFromCenter(d, d2, d + d3 / 2.0, d2 + d4 / 2.0);
        Cloud cloud = new Cloud(double_);
        CloudGraphic cloudGraphic = new CloudGraphic(cloud);
        this.cloudsToGraphicMap.put(cloud, cloudGraphic);
    }

    public void cloudsEnabled(boolean bl) {
        Set set = this.cloudsToGraphicMap.keySet();
        for (Cloud cloud : set) {
            if (!this.cloudsEnabled && bl) {
                this.getGreenhouseModel().addCloud(cloud);
                this.getApparatusPanel().addGraphic((Graphic)this.cloudsToGraphicMap.get(cloud), 0.0);
                continue;
            }
            if (!this.cloudsEnabled || bl) continue;
            this.getGreenhouseModel().removeCloud(cloud);
            this.getApparatusPanel().removeGraphic((Graphic)this.cloudsToGraphicMap.get(cloud));
        }
        this.cloudsEnabled = bl;
    }

    public void numCloudsEnabled(int n) {
        Set set = this.cloudsToGraphicMap.keySet();
        int n2 = 0;
        for (Cloud cloud : set) {
            this.getGreenhouseModel().removeCloud(cloud);
            this.getApparatusPanel().removeGraphic((Graphic)this.cloudsToGraphicMap.get(cloud));
        }
        for (Cloud cloud : set) {
            if (++n2 > n) continue;
            this.getGreenhouseModel().addCloud(cloud);
            this.getApparatusPanel().addGraphic((Graphic)this.cloudsToGraphicMap.get(cloud), 0.0);
        }
    }
}

