/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.PhetTitledBorder;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.GreenhouseLegend;
import edu.colorado.phet.greenhouse.GreenhouseModule;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.model.GreenhouseModel;
import edu.colorado.phet.greenhouse.util.ModelViewTx1D;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GreenhouseControlPanel
extends JPanel
implements Resettable {
    private static Color adjustableGGColor = Color.black;
    private static Color iceAgeColor = new Color(0, 28, 229);
    private static Color preIndRevColor = new Color(176, 0, 219);
    private static Color todayColor = new Color(11, 142, 0);
    private static Font BORDER_TITLE_FONT = new PhetFont(12, true);
    private final ModelSlider greenhouseGasConcentrationControl;
    String[] iceAgeConcentrations = new String[]{" ?", "180 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation"), "0.380 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation"), "0.215 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation")};
    String[] preIndRevConcentrations = new String[]{"70% " + GreenhouseResources.getString("GreenhouseControlPanel.RelativeHumidityAbbreviation"), "280 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation"), "0.730 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation"), "0.270 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation")};
    String[] todayConcentrations = new String[]{"70% " + GreenhouseResources.getString("GreenhouseControlPanel.RelativeHumidityAbbreviation"), "388 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation"), "1.843 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation"), "0.317 " + GreenhouseResources.getString("GreenhouseControlPanel.PPMAbreviation")};
    String[] venusConcentrations = new String[]{"", "96.5% ", "", ""};
    private final GreenhouseCompositionPane iceAgeCompositionPane = new GreenhouseCompositionPane(this.iceAgeConcentrations, iceAgeColor);
    private final GreenhouseCompositionPane seventeenFiftyCompositionPane = new GreenhouseCompositionPane(this.preIndRevConcentrations, preIndRevColor);
    private final GreenhouseCompositionPane todayCompositionPane = new GreenhouseCompositionPane(this.todayConcentrations, todayColor);
    private final GreenhouseCompositionPane venusCompositionPane = new GreenhouseCompositionPane(this.venusConcentrations, Color.black);
    private final JPanel adjustableCompositionPane = new JPanel();
    private final GreenhouseModule module;
    private final JSpinner cloudsSpinner;
    private final AtmosphereSelectionPanel atmosphereSelectionPane;
    private final JCheckBox allPhotonsCB;
    private final JCheckBox thermometerCB;
    private final JRadioButton fahrenheitRB;
    private final JRadioButton celsiusRB;

    public GreenhouseControlPanel(final GreenhouseModule greenhouseModule) {
        this.module = greenhouseModule;
        final GreenhouseModel greenhouseModel = greenhouseModule.getGreenhouseModel();
        final SliderWithReadout sliderWithReadout = new SliderWithReadout(GreenhouseResources.getString("GreenhouseControlPanel.SunRateSlider"), "", 0.0, 0.1, GreenhouseConfig.defaultSunPhotonProductionRate);
        sliderWithReadout.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                greenhouseModel.setSunPhotonProductionRate(sliderWithReadout.getModelValue());
            }
        });
        final SliderWithReadout sliderWithReadout2 = new SliderWithReadout(GreenhouseResources.getString("GreenhouseControlPanel.EarthEmissivitySlider"), "", 0.0, GreenhouseConfig.maxEarthEmissivity, GreenhouseConfig.defaultEarthEmissivity);
        sliderWithReadout2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                greenhouseModel.setEarthEmissivity(sliderWithReadout2.getModelValue());
            }
        });
        this.greenhouseGasConcentrationControl = new ModelSlider("", 0.0, GreenhouseConfig.maxGreenhouseGasConcentration, GreenhouseConfig.defaultGreenhouseGasConcentration);
        this.greenhouseGasConcentrationControl.setMaxValue(GreenhouseConfig.maxGreenhouseGasConcentration);
        this.greenhouseGasConcentrationControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                greenhouseModel.setGreenhouseGasConcentration(GreenhouseControlPanel.this.greenhouseGasConcentrationControl.getModelValue());
            }
        });
        this.greenhouseGasConcentrationControl.addSliderListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GreenhouseControlPanel.this.atmosphereSelectionPane.setAdjustableAtmosphere();
            }
        });
        JPanel jPanel = new JPanel();
        int n = 0;
        int n2 = 3;
        int n3 = 1;
        int n4 = 0;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n4, n, n2, n3);
        this.cloudsSpinner = new JSpinner(spinnerNumberModel);
        this.cloudsSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                int n = (Integer)jSpinner.getValue();
                greenhouseModule.numCloudsEnabled(n);
            }
        });
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.cloudsSpinner.getEditor()).getTextField();
        jFormattedTextField.setEditable(false);
        jFormattedTextField.setBackground(Color.white);
        jPanel.add(this.cloudsSpinner);
        jPanel.add(new JLabel(GreenhouseResources.getString("GreenhouseControlPanel.NumberOfCloudsLabel")));
        this.thermometerCB = new JCheckBox(GreenhouseResources.getString("GreenhouseControlPanel.ThermometerCheckbox"));
        this.thermometerCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                greenhouseModule.thermometerEnabled(GreenhouseControlPanel.this.thermometerCB.isSelected());
                GreenhouseControlPanel.this.fahrenheitRB.setEnabled(GreenhouseControlPanel.this.thermometerCB.isSelected());
                GreenhouseControlPanel.this.celsiusRB.setEnabled(GreenhouseControlPanel.this.thermometerCB.isSelected());
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fahrenheitRB = new JRadioButton(GreenhouseResources.getString("GreenhouseControlPanel.Faherenheit"));
        this.celsiusRB = new JRadioButton(GreenhouseResources.getString("GreenhouseControlPanel.Celsius"));
        buttonGroup.add(this.fahrenheitRB);
        buttonGroup.add(this.celsiusRB);
        TemperatureUnitsSetter temperatureUnitsSetter = new TemperatureUnitsSetter();
        this.fahrenheitRB.addActionListener(temperatureUnitsSetter);
        this.celsiusRB.addActionListener(temperatureUnitsSetter);
        this.fahrenheitRB.setSelected(true);
        this.allPhotonsCB = new JCheckBox(GreenhouseResources.getString("GreenhouseControlPanel.ViewPhotonsCheckbox"));
        this.allPhotonsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GreenhouseControlPanel.this.allPhotonsCB.isSelected()) {
                    greenhouseModule.setVisiblePhotonRatio(1.0);
                } else {
                    greenhouseModule.setVisiblePhotonRatio(0.1);
                }
            }
        });
        this.atmosphereSelectionPane = new AtmosphereSelectionPanel();
        ResetAllButton resetAllButton = new ResetAllButton(this, (Component)PhetApplication.getInstance().getPhetFrame());
        this.setDefaultConditions();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)new GreenhouseLegend(BORDER_TITLE_FONT), gridBagConstraints);
        PhetTitledPanel phetTitledPanel = new PhetTitledPanel(GreenhouseResources.getString("GreenhouseControlPanel.GasConcentrationSlider"), BORDER_TITLE_FONT);
        phetTitledPanel.add(this.greenhouseGasConcentrationControl);
        this.add((Component)phetTitledPanel, gridBagConstraints);
        phetTitledPanel = new PhetTitledPanel(GreenhouseResources.getString("GreenhouseControlPanel.Options"), BORDER_TITLE_FONT);
        phetTitledPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 15, 0, 15);
        Insets insets2 = new Insets(0, 2, 0, 2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0);
        gridBagConstraints2.gridwidth = 2;
        phetTitledPanel.add((Component)jPanel, gridBagConstraints2);
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridy;
        phetTitledPanel.add((Component)this.thermometerCB, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = insets2;
        phetTitledPanel.add((Component)this.fahrenheitRB, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        phetTitledPanel.add((Component)this.celsiusRB, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = insets;
        phetTitledPanel.add((Component)this.allPhotonsCB, gridBagConstraints2);
        gridBagConstraints.fill = 2;
        this.add((Component)this.atmosphereSelectionPane, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        this.add((Component)phetTitledPanel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 15);
        this.add((Component)resetAllButton, gridBagConstraints);
    }

    private void setDefaultConditions() {
        this.cloudsSpinner.setValue(new Integer(0));
        this.allPhotonsCB.setSelected(false);
        this.module.setVisiblePhotonRatio(0.1);
        this.thermometerCB.setSelected(true);
        this.fahrenheitRB.setEnabled(this.thermometerCB.isSelected());
        this.celsiusRB.setEnabled(this.thermometerCB.isSelected());
        this.fahrenheitRB.setSelected(true);
        this.updateTemperatureUnits();
    }

    public void reset() {
        this.module.reset();
        this.atmosphereSelectionPane.reset();
        this.setDefaultConditions();
        this.module.thermometerEnabled(this.thermometerCB.isSelected());
    }

    private void updateTemperatureUnits() {
        if (this.fahrenheitRB.isSelected()) {
            GreenhouseConfig.TEMPERATURE_UNITS = GreenhouseConfig.FAHRENHEIT;
        } else if (this.celsiusRB.isSelected()) {
            GreenhouseConfig.TEMPERATURE_UNITS = GreenhouseConfig.CELSIUS;
        }
    }

    public class GreenhouseTextField
    extends JTextField {
        public GreenhouseTextField() {
            super(10);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setOpaque(false);
        }
    }

    private class TemperatureUnitsSetter
    implements ActionListener {
        private TemperatureUnitsSetter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GreenhouseControlPanel.this.updateTemperatureUnits();
        }
    }

    class SliderWithReadout
    extends JPanel {
        private final JTextField modelValueTF;
        private final JSlider slider;
        private final ModelViewTx1D tx;
        private final String units;

        SliderWithReadout(String string, String string2, double d, double d2, double d3) {
            this.units = string2;
            this.setLayout(new GridBagLayout());
            this.modelValueTF = new JTextField(10);
            this.setModelValueTF(d3);
            this.tx = new ModelViewTx1D(d, d2, 0, 100);
            this.slider = new JSlider(0, 0, 100, (int)this.tx.modelToView(d3));
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = SliderWithReadout.this.tx.viewToModel(SliderWithReadout.this.slider.getValue());
                    SliderWithReadout.this.setModelValueTF(d);
                }
            });
            int n = 0;
            try {
                SwingUtils.addGridBagComponent(this, new JLabel(string), 0, n++, 1, 1, 0, 10);
                SwingUtils.addGridBagComponent(this, this.slider, 0, n++, 1, 1, 0, 10);
                SwingUtils.addGridBagComponent(this, this.modelValueTF, 0, n++, 1, 1, 0, 10);
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
        }

        private void setModelValueTF(double d) {
            this.modelValueTF.setText("  " + Double.toString(d) + " " + this.units);
        }

        double getModelValue() {
            return this.tx.viewToModel(this.slider.getValue());
        }

        void addChangeListener(ChangeListener changeListener) {
            this.slider.addChangeListener(changeListener);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.slider.setEnabled(bl);
        }
    }

    class ModelSlider
    extends JPanel {
        private final JSlider slider;
        private final ModelViewTx1D tx;

        ModelSlider(String string, double d, double d2, double d3) {
            this.setLayout(new GridBagLayout());
            this.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            this.tx = new ModelViewTx1D(d, d2, 0, 10000);
            this.slider = new JSlider(0, 0, 10000, (int)this.tx.modelToView(d3));
            this.slider.setPaintLabels(true);
            int n = 0;
            try {
                SwingUtils.addGridBagComponent(this, new JLabel(string), 0, n++, 1, 1, 0, 10);
                SwingUtils.addGridBagComponent(this, this.slider, 0, n++, 1, 1, 0, 10);
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            PhetFont phetFont = new PhetFont();
            Font font = new Font(phetFont.getName(), 1, phetFont.getSize() + 6);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            JLabel jLabel = new JLabel("|");
            jLabel.setFont(font);
            jLabel.setForeground(iceAgeColor);
            JLabel jLabel2 = new JLabel("|");
            jLabel2.setFont(font);
            jLabel2.setForeground(preIndRevColor);
            JLabel jLabel3 = new JLabel("|");
            jLabel3.setFont(font);
            jLabel3.setForeground(todayColor);
            hashtable.put(new Integer((int)this.tx.modelToView(GreenhouseConfig.greenhouseGasConcentrationIceAge)), jLabel);
            hashtable.put(new Integer((int)this.tx.modelToView(GreenhouseConfig.greenhouseGasConcentrationToday)), jLabel3);
            hashtable.put(new Integer((int)this.tx.modelToView(GreenhouseConfig.greenhouseGasConcentration1750)), jLabel2);
            JLabel jLabel4 = new JLabel(GreenhouseResources.getString("GreenhouseControlPanel.None"));
            JLabel jLabel5 = new JLabel(GreenhouseResources.getString("GreenhouseControlPanel.Lots"));
            hashtable.put(new Integer((int)this.tx.modelToView(d2)), jLabel5);
            hashtable.put(new Integer((int)this.tx.modelToView(d)), jLabel4);
            this.slider.setLabelTable(hashtable);
            this.slider.setMajorTickSpacing((int)(this.tx.modelToView(d2) - this.tx.modelToView(d)));
            this.slider.setPaintTicks(true);
        }

        void setMaxValue(double d) {
            int n = (int)this.tx.modelToView(d);
            this.slider.setMaximum(n);
        }

        double getModelValue() {
            return this.tx.viewToModel(this.slider.getValue());
        }

        void addChangeListener(ChangeListener changeListener) {
            this.slider.addChangeListener(changeListener);
        }

        void setModelValue(double d) {
            this.slider.setValue((int)this.tx.modelToView(d));
            this.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.slider.setEnabled(bl);
        }

        void addSliderListener(MouseListener mouseListener) {
            this.slider.addMouseListener(mouseListener);
        }
    }

    private class GreenhouseCompositionPane
    extends PhetTitledPanel {
        JTextField h2oTF;
        JTextField co2TF;
        JTextField ch4TF;
        JTextField n2oTF;

        GreenhouseCompositionPane(String[] stringArray, Color color) {
            this();
            this.setConcentrations(stringArray);
            this.setTitleColor(color);
        }

        GreenhouseCompositionPane() {
            super(GreenhouseResources.getString("GreenhouseControlPanel.GreenhouseGasBorderLabel"), BORDER_TITLE_FONT);
            this.h2oTF = new GreenhouseTextField();
            this.co2TF = new GreenhouseTextField();
            this.ch4TF = new GreenhouseTextField();
            this.n2oTF = new GreenhouseTextField();
            this.setFont(new PhetFont(8));
            String[] stringArray = new String[]{GreenhouseResources.getString("GreenhouseControlPanel.H2OLabel"), GreenhouseResources.getString("GreenhouseControlPanel.CO2Label"), GreenhouseResources.getString("GreenhouseControlPanel.CH4Label"), GreenhouseResources.getString("GreenhouseControlPanel.N2OLabel")};
            JTextField[] jTextFieldArray = new JTextField[]{this.h2oTF, this.co2TF, this.ch4TF, this.n2oTF};
            this.h2oTF.setEditable(false);
            this.co2TF.setEditable(false);
            this.ch4TF.setEditable(false);
            this.n2oTF.setEditable(false);
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
            easyGridBagLayout.setFill(2);
            this.setLayout(easyGridBagLayout);
            for (int i = 0; i < jTextFieldArray.length; ++i) {
                int n = 0;
                easyGridBagLayout.addAnchoredComponent(new JLabel(stringArray[i]), i, n++, 13);
                easyGridBagLayout.addAnchoredComponent(jTextFieldArray[i], i, n++, 17);
            }
        }

        public void setConcentrations(String[] stringArray) {
            this.h2oTF.setText(stringArray[0]);
            this.co2TF.setText(stringArray[1]);
            this.ch4TF.setText(stringArray[2]);
            this.n2oTF.setText(stringArray[3]);
        }

        public void setTitleColor(Color color) {
            if (this.getBorder() instanceof TitledBorder) {
                ((TitledBorder)this.getBorder()).setTitleColor(color);
            } else {
                System.err.println(this.getClass().getName() + " - Error: Border is not a titled border, ignoring attempt to set color.");
            }
        }
    }

    private class AtmosphereSelectionPanel
    extends JPanel {
        private final JRadioButton todayGGRB;
        private final JRadioButton adjustableGGRB;
        AbstractAction pickAdjustableGG = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AtmosphereSelectionPanel.this.setAdjustableAtmosphere();
            }
        };
        private final AbstractAction pickIceAgeGG = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GreenhouseControlPanel.this.greenhouseGasConcentrationControl.setModelValue(GreenhouseConfig.greenhouseGasConcentrationIceAge);
                GreenhouseControlPanel.this.module.setIceAge();
                GreenhouseControlPanel.this.module.getEarth().setBaseTemperature(251.0);
                AtmosphereSelectionPanel.this.hideConcentrations();
                GreenhouseControlPanel.this.iceAgeCompositionPane.setVisible(true);
            }
        };
        private final AbstractAction pickPreIndRevGG = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GreenhouseControlPanel.this.greenhouseGasConcentrationControl.setModelValue(GreenhouseConfig.greenhouseGasConcentration1750);
                GreenhouseControlPanel.this.module.setPreIndRev();
                GreenhouseControlPanel.this.module.getEarth().setBaseTemperature(251.0);
                AtmosphereSelectionPanel.this.hideConcentrations();
                GreenhouseControlPanel.this.seventeenFiftyCompositionPane.setVisible(true);
            }
        };
        private final AbstractAction pickTodayGG = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GreenhouseControlPanel.this.greenhouseGasConcentrationControl.setModelValue(GreenhouseConfig.greenhouseGasConcentrationToday);
                GreenhouseControlPanel.this.module.setToday();
                GreenhouseControlPanel.this.module.getEarth().setBaseTemperature(251.0);
                AtmosphereSelectionPanel.this.hideConcentrations();
                GreenhouseControlPanel.this.todayCompositionPane.setVisible(true);
            }
        };

        AtmosphereSelectionPanel() {
            this.setBorder(new PhetTitledBorder(GreenhouseResources.getString("GreenhouseControlPanel.TimePeriodBorderLabel"), BORDER_TITLE_FONT));
            this.adjustableGGRB = new JRadioButton();
            this.adjustableGGRB.setAction(this.pickAdjustableGG);
            this.adjustableGGRB.setText(GreenhouseResources.getString("GreenhouseControlPanel.Adjustable"));
            this.adjustableGGRB.setForeground(adjustableGGColor);
            JRadioButton jRadioButton = new JRadioButton();
            jRadioButton.setAction(this.pickIceAgeGG);
            jRadioButton.setText(GreenhouseResources.getString("GreenhouseControlPanel.IceAgeLabel"));
            jRadioButton.setForeground(iceAgeColor);
            JRadioButton jRadioButton2 = new JRadioButton();
            jRadioButton2.setAction(this.pickPreIndRevGG);
            jRadioButton2.setText(GreenhouseResources.getString("GreenhouseControlPanel.PreIndustrialLabel"));
            jRadioButton2.setForeground(preIndRevColor);
            this.todayGGRB = new JRadioButton();
            this.todayGGRB.setAction(this.pickTodayGG);
            this.todayGGRB.setText(GreenhouseResources.getString("GreenhouseControlPanel.TodayLabel"));
            this.todayGGRB.setForeground(todayColor);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.todayGGRB);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
            buttonGroup.add(this.adjustableGGRB);
            GreenhouseControlPanel.this.iceAgeCompositionPane.setVisible(false);
            GreenhouseControlPanel.this.seventeenFiftyCompositionPane.setVisible(false);
            GreenhouseControlPanel.this.todayCompositionPane.setVisible(false);
            GreenhouseControlPanel.this.venusCompositionPane.setVisible(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            this.add((Component)this.todayGGRB, gridBagConstraints);
            this.add((Component)jRadioButton2, gridBagConstraints);
            this.add((Component)jRadioButton, gridBagConstraints);
            this.add((Component)this.adjustableGGRB, gridBagConstraints);
            this.add((Component)GreenhouseControlPanel.this.adjustableCompositionPane, gridBagConstraints);
            this.add((Component)GreenhouseControlPanel.this.seventeenFiftyCompositionPane, gridBagConstraints);
            this.add((Component)GreenhouseControlPanel.this.iceAgeCompositionPane, gridBagConstraints);
            this.add((Component)GreenhouseControlPanel.this.todayCompositionPane, gridBagConstraints);
            this.setDefaultConditions();
        }

        private void setAdjustableAtmosphere() {
            GreenhouseControlPanel.this.module.setVirginEarth();
            GreenhouseControlPanel.this.module.getEarth().setBaseTemperature(251.0);
            this.hideConcentrations();
            GreenhouseControlPanel.this.adjustableCompositionPane.setPreferredSize(GreenhouseControlPanel.this.iceAgeCompositionPane.getPreferredSize());
            GreenhouseControlPanel.this.adjustableCompositionPane.setVisible(true);
            this.adjustableGGRB.setSelected(true);
        }

        public void reset() {
            this.setDefaultConditions();
        }

        private void setDefaultConditions() {
            this.todayGGRB.setSelected(true);
            GreenhouseControlPanel.this.greenhouseGasConcentrationControl.setModelValue(GreenhouseConfig.greenhouseGasConcentrationToday);
            GreenhouseControlPanel.this.module.getEarth().setBaseTemperature(251.0);
            this.hideConcentrations();
            GreenhouseControlPanel.this.todayCompositionPane.setVisible(true);
        }

        private void hideConcentrations() {
            GreenhouseControlPanel.this.iceAgeCompositionPane.setVisible(false);
            GreenhouseControlPanel.this.seventeenFiftyCompositionPane.setVisible(false);
            GreenhouseControlPanel.this.todayCompositionPane.setVisible(false);
            GreenhouseControlPanel.this.venusCompositionPane.setVisible(false);
            GreenhouseControlPanel.this.adjustableCompositionPane.setVisible(false);
        }
    }
}

