/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.photonabsorption.model.PhotonEmitter;
import edu.colorado.phet.greenhouse.BaseGreenhouseModule;
import edu.colorado.phet.greenhouse.GlassPaneControlPanel;
import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.common.graphics.Graphic;
import edu.colorado.phet.greenhouse.common.graphics.ImageGraphic;
import edu.colorado.phet.greenhouse.model.GlassPane;
import edu.colorado.phet.greenhouse.model.GreenhouseModel;
import edu.colorado.phet.greenhouse.model.PhotonAbsorber;
import edu.colorado.phet.greenhouse.view.GlassPaneGraphic;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class GlassPaneModule
extends BaseGreenhouseModule {
    private GlassPane glassPane;
    private GlassPaneGraphic glassPaneGraphic;
    private HashMap glassPanesToGraphicMap = new HashMap();
    private int numGlassPanes = 3;
    private ArrayList glassPanes = new ArrayList();
    private double[][] jimmyArray = new double[][]{{0.0, 0.0}, {255.0, 255.0}, {272.0, 303.0}, {283.0, 335.0}, {286.0, 361.0}, {1000.0, 1400.0}};
    private ImageGraphic backgroundGraphic = new ImageGraphic("glass-pane-background.gif", new Point2D.Double(this.getGreenhouseModel().getBounds().getX(), this.getGreenhouseModel().getBounds().getY()));

    public GlassPaneModule() {
        super(GreenhouseResources.getString("ModuleTitle.GlassLayerModule"));
        this.drawingCanvas.addGraphic(this.backgroundGraphic, -1.5);
        for (int i = 0; i < this.numGlassPanes; ++i) {
            this.glassPane = new GlassPane(this.getFinalModelBounds().getMinX(), this.getFinalModelBounds().getWidth(), 5 + i * 2);
            this.glassPaneGraphic = new GlassPaneGraphic(this.glassPane, this.backgroundGraphic, this.getFinalModelBounds());
            this.glassPane.addListener(new BaseGreenhouseModule.PhotonEmitterListener());
            this.glassPane.addListener((PhotonEmitter.Listener)((Object)this.getModel()));
            this.glassPane.addListener(new BaseGreenhouseModule.PhotonAbsorberListener());
            this.glassPane.addListener((PhotonAbsorber.Listener)((Object)this.getModel()));
            this.glassPanesToGraphicMap.put(this.glassPane, this.glassPaneGraphic);
            this.glassPanes.add(this.glassPane);
        }
        this.getApparatusPanel().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Rectangle rectangle = component.getBounds();
                if (((RectangularShape)rectangle).getWidth() <= 0.0 || ((RectangularShape)rectangle).getHeight() <= 0.0) {
                    return;
                }
                if (GlassPaneModule.this.backgroundGraphic != null) {
                    BufferedImage bufferedImage;
                    try {
                        bufferedImage = ImageLoader.loadBufferedImage("greenhouse/images/glass-pane-background.gif");
                    }
                    catch (IOException iOException) {
                        System.err.println("ERROR: Unable to reload glass pane background image.");
                        iOException.printStackTrace();
                        return;
                    }
                    double d = ((RectangularShape)rectangle).getWidth() / (double)bufferedImage.getWidth();
                    AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
                    AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
                    bufferedImage = affineTransformOp.filter(bufferedImage, null);
                    Rectangle2D.Double double_ = ((GreenhouseModel)GlassPaneModule.this.getModel()).getBounds();
                    GlassPaneModule.this.getApparatusPanel().removeGraphic(GlassPaneModule.this.backgroundGraphic);
                    GlassPaneModule.this.backgroundGraphic = new ImageGraphic(bufferedImage, new Point2D.Double(-((RectangularShape)double_).getWidth() / 2.0, -0.5));
                    GlassPaneModule.this.getApparatusPanel().addGraphic(GlassPaneModule.this.backgroundGraphic, -1.5);
                }
            }
        });
        this.setControlPanel(new GlassPaneControlPanel(this));
        this.getEarth().setJimmyArray(this.jimmyArray);
    }

    public void reset() {
        super.reset();
    }

    public void numGlassPanesEnabled(int n) {
        for (GlassPane glassPane : this.glassPanes) {
            this.getGreenhouseModel().removeGlassPane(glassPane);
            this.getApparatusPanel().removeGraphic((Graphic)this.glassPanesToGraphicMap.get(glassPane));
        }
        for (int i = 0; i < n; ++i) {
            GlassPane glassPane;
            glassPane = (GlassPane)this.glassPanes.get(i);
            this.getGreenhouseModel().addGlassPane(glassPane);
            double d = (GreenhouseConfig.IR_PHOTON_GRAPHIC_LAYER + GreenhouseConfig.SUNLIGHT_PHOTON_GRAPHIC_LAYER) / 2.0;
            this.getApparatusPanel().addGraphic((Graphic)this.glassPanesToGraphicMap.get(glassPane), d);
        }
    }

    public int getMaxGlassPanes() {
        return this.numGlassPanes;
    }
}

