/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.greenhouse.GlassPaneModule;
import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.GreenhouseLegend;
import edu.colorado.phet.greenhouse.GreenhouseResources;
import edu.colorado.phet.greenhouse.util.MessageFormatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GlassPaneControlPanel
extends JPanel
implements Resettable {
    private static Color panelBackground = GreenhouseConfig.PANEL_BACKGROUND_COLOR;
    private GlassPaneModule module;
    private JSpinner glassPaneSpinner;
    private JCheckBox allPhotonsCB;
    private JCheckBox thermometerCB;

    public GlassPaneControlPanel(final GlassPaneModule glassPaneModule) {
        this.module = glassPaneModule;
        JPanel jPanel = new JPanel();
        int n = 0;
        int n2 = glassPaneModule.getMaxGlassPanes();
        int n3 = 1;
        int n4 = 0;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n4, n, n2, n3);
        this.glassPaneSpinner = new JSpinner(spinnerNumberModel);
        this.glassPaneSpinner.getEditor().setBackground(Color.white);
        this.glassPaneSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                int n = (Integer)jSpinner.getValue();
                glassPaneModule.numGlassPanesEnabled(n);
            }
        });
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.glassPaneSpinner.getEditor()).getTextField();
        jFormattedTextField.setEditable(false);
        jFormattedTextField.setBackground(Color.white);
        jPanel.add(this.glassPaneSpinner);
        jPanel.add(new JLabel(MessageFormatter.format(GreenhouseResources.getString("GlassPaneControlPanel.GlassPaneLabel"))));
        this.thermometerCB = new JCheckBox(GreenhouseResources.getString("GlassPaneControlPanel.ThermometerCheckbox"));
        this.thermometerCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                glassPaneModule.thermometerEnabled(GlassPaneControlPanel.this.thermometerCB.isSelected());
            }
        });
        this.allPhotonsCB = new JCheckBox(GreenhouseResources.getString("GlassPaneControlPanel.ViewPhotonsCheckbox"));
        this.allPhotonsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GlassPaneControlPanel.this.allPhotonsCB.isSelected()) {
                    glassPaneModule.setVisiblePhotonRatio(1.0);
                } else {
                    glassPaneModule.setVisiblePhotonRatio(0.1);
                }
            }
        });
        this.setDefaultConditions();
        ResetAllButton resetAllButton = new ResetAllButton(this, (Component)PhetApplication.getInstance().getPhetFrame());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        jPanel2.add((Component)new GreenhouseLegend(), gridBagConstraints);
        PhetTitledPanel phetTitledPanel = new PhetTitledPanel(GreenhouseResources.getString("GreenhouseControlPanel.Options"));
        phetTitledPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 25, 0, 25), 0, 0);
        phetTitledPanel.add((Component)jPanel, gridBagConstraints2);
        phetTitledPanel.add((Component)this.thermometerCB, gridBagConstraints2);
        phetTitledPanel.add((Component)this.allPhotonsCB, gridBagConstraints2);
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)phetTitledPanel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(15, 15, 0, 15);
        jPanel2.add((Component)resetAllButton, gridBagConstraints);
        this.add(jPanel2);
        this.setBackground(this);
    }

    private void setDefaultConditions() {
        this.glassPaneSpinner.setValue(new Integer(0));
        this.thermometerCB.setSelected(true);
        this.module.thermometerEnabled(this.thermometerCB.isSelected());
        this.allPhotonsCB.setSelected(false);
        this.module.setVisiblePhotonRatio(0.1);
    }

    public void reset() {
        this.module.reset();
        this.setDefaultConditions();
    }

    private void setBackground(Container container) {
        container.setBackground(panelBackground);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JLabel || component instanceof JCheckBox) {
                // empty if block
            }
            if (!(component instanceof JButton)) {
                // empty if block
            }
            if (!component.getForeground().equals(Color.black) || !(component instanceof JButton)) {
                // empty if block
            }
            if (!(component instanceof Container) || component instanceof JButton || component instanceof JSpinner) continue;
            this.setBackground((Container)component);
        }
    }
}

