/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.greenhouse;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.photonabsorption.model.PhotonEmitter;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.greenhouse.ClockDelaySlider;
import edu.colorado.phet.greenhouse.GreenhouseApplication;
import edu.colorado.phet.greenhouse.GreenhouseConfig;
import edu.colorado.phet.greenhouse.common.graphics.ApparatusPanel;
import edu.colorado.phet.greenhouse.common.graphics.CompositeGraphic;
import edu.colorado.phet.greenhouse.filter.Filter1D;
import edu.colorado.phet.greenhouse.filter.IrFilter;
import edu.colorado.phet.greenhouse.model.Atmosphere;
import edu.colorado.phet.greenhouse.model.BlackHole;
import edu.colorado.phet.greenhouse.model.Earth;
import edu.colorado.phet.greenhouse.model.GreenhouseClock;
import edu.colorado.phet.greenhouse.model.GreenhouseModel;
import edu.colorado.phet.greenhouse.model.Photon;
import edu.colorado.phet.greenhouse.model.PhotonAbsorber;
import edu.colorado.phet.greenhouse.model.ScatterEvent;
import edu.colorado.phet.greenhouse.model.Star;
import edu.colorado.phet.greenhouse.model.Thermometer;
import edu.colorado.phet.greenhouse.view.AtmosphereGraphic;
import edu.colorado.phet.greenhouse.view.EarthGraphic;
import edu.colorado.phet.greenhouse.view.FlipperAffineTransformFactory;
import edu.colorado.phet.greenhouse.view.PhotonGraphic;
import edu.colorado.phet.greenhouse.view.ScatterEventGraphic;
import edu.colorado.phet.greenhouse.view.TestApparatusPanel;
import edu.colorado.phet.greenhouse.view.ThermometerGraphic;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BaseGreenhouseModule
extends Module {
    private final HashMap photonToGraphicsMap = new HashMap();
    protected CompositeGraphic drawingCanvas;
    private ThermometerGraphic thermometerGraphic;
    protected EarthGraphic earthGraphic;
    private PhotonEmitterListener earthPhotonEmitterListener;
    private PhotonEmitterListener sunPhotonEmitterListener;
    private boolean thermometerEnabled;
    double exposedEarth = 1.0;
    private int invisiblePhotonCnt = 10;
    private Earth earth;
    HashMap scatterToGraphicMap = new HashMap();
    private static final double EARTH_DIAM = Earth.radius * 2.0;
    private static final double SUN_DIAM = EARTH_DIAM * 5.0;
    private static final double SUN_EARTH_DIST = SUN_DIAM * 5.0;
    private Star sun;
    private ApparatusPanel apparatusPanel;
    private GreenhouseModel model;
    private static boolean s_firstTime = true;
    private Rectangle2D.Double modelBounds;
    private AtmosphereGraphic atmosphereGraphic;
    private ClockDelaySlider timeSpeedSlider;

    protected BaseGreenhouseModule(String string) {
        super(string, new GreenhouseClock());
        this.init();
    }

    private void init() {
        PiccoloClockControlPanel piccoloClockControlPanel = new PiccoloClockControlPanel(this.getClock());
        this.timeSpeedSlider = new ClockDelaySlider(150, 30, "0.00", this.getGreenhouseClock(), null);
        this.timeSpeedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BaseGreenhouseModule.this.getGreenhouseClock().setDelay((int)Math.round(150.0 / BaseGreenhouseModule.this.timeSpeedSlider.getValue()));
            }
        });
        piccoloClockControlPanel.addBetweenTimeDisplayAndButtons(this.timeSpeedSlider);
        this.setClockControlPanel(piccoloClockControlPanel);
        double d = EARTH_DIAM + SUN_DIAM + SUN_EARTH_DIST * 2.0;
        d = this.exposedEarth + 16.0;
        this.modelBounds = new Rectangle2D.Double(-d * 4.0 / 3.0 / 2.0, -this.exposedEarth, d * 4.0 / 3.0, d);
        this.model = new GreenhouseModel(this.modelBounds);
        this.setModel(this.model);
        this.apparatusPanel = new TestApparatusPanel(1.0, new FlipperAffineTransformFactory(this.modelBounds));
        this.setSimulationPanel(this.apparatusPanel);
        this.apparatusPanel.setBackground(Color.black);
        this.drawingCanvas = this.apparatusPanel.getCompositeGraphic();
        this.earthPhotonEmitterListener = new PhotonEmitterListener();
        double d2 = Math.atan(this.modelBounds.getWidth() / 2.0 / Earth.radius);
        this.earth = new Earth(new Point2D.Double(0.0, -Earth.radius + this.exposedEarth), 1.5707963267948966 - d2, 1.5707963267948966 + d2);
        this.model.setEarth(this.earth);
        this.earth.getPhotonSource().setProductionRate(0.01);
        this.earth.addPhotonEmitterListener(this.earthPhotonEmitterListener);
        this.earth.addPhotonAbsorberListener(new PhotonAbsorberListener());
        this.earth.getPhotonSource().addListener(this.model);
        this.earthGraphic = new EarthGraphic(this.getApparatusPanel(), this.earth, this.modelBounds);
        this.earth.setReflectivityAssessor(this.earthGraphic);
        Atmosphere atmosphere = new Atmosphere(this.earth);
        this.model.setAtmosphere(atmosphere);
        this.atmosphereGraphic = new AtmosphereGraphic(atmosphere, this.modelBounds, this.apparatusPanel);
        atmosphere.addScatterEventListener(new ModuleScatterEventListener());
        this.atmosphereGraphic.setVisible(false);
        this.drawingCanvas.addGraphic(this.atmosphereGraphic, Double.MAX_VALUE);
        this.model.addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                BaseGreenhouseModule.this.atmosphereGraphic.update(null, null);
            }
        });
        this.sun = new Star(SUN_DIAM / 2.0, new Point2D.Double(0.0, EARTH_DIAM + SUN_EARTH_DIST + SUN_DIAM / 2.0), new Rectangle2D.Double(this.modelBounds.getX(), this.modelBounds.getY() + this.modelBounds.getHeight(), this.modelBounds.getWidth() / 1.0, 1.0));
        this.sun.setProductionRate(0.0);
        this.sunPhotonEmitterListener = new PhotonEmitterListener();
        this.sun.addListener(this.sunPhotonEmitterListener);
        this.model.setSun(this.sun);
        BlackHole blackHole = new BlackHole(this.model);
        blackHole.addListener(this.model);
        blackHole.addListener(new PhotonAbsorberListener());
        this.model.addModelElement(blackHole);
        Thermometer thermometer = new Thermometer(this.earth);
        thermometer.setLocation(new Point2D.Double(this.modelBounds.getX() + 2.0, 0.5));
        this.model.addModelElement(thermometer);
        this.thermometerGraphic = new ThermometerGraphic(thermometer);
        this.thermometerEnabled(false);
        if (s_firstTime) {
            s_firstTime = false;
            this.earthGraphic.setNoBackdrop();
            ((TestApparatusPanel)this.getApparatusPanel()).setModelBounds(this.modelBounds);
            this.atmosphereGraphic.setVisible(true);
            this.thermometerEnabled(true);
            GreenhouseApplication.paintContentImmediately();
            this.sun.setProductionRate(GreenhouseConfig.defaultSunPhotonProductionRate);
            this.setToday();
        } else {
            ((TestApparatusPanel)this.getApparatusPanel()).setModelBounds(this.modelBounds);
            this.atmosphereGraphic.setVisible(true);
            this.thermometerEnabled(true);
            this.getApparatusPanel().setAffineTransformFactory(new FlipperAffineTransformFactory(this.modelBounds));
            this.sun.setProductionRate(GreenhouseConfig.defaultSunPhotonProductionRate);
        }
    }

    public GreenhouseModel getGreenhouseModel() {
        return this.model;
    }

    public GreenhouseClock getGreenhouseClock() {
        return (GreenhouseClock)super.getClock();
    }

    protected ApparatusPanel getApparatusPanel() {
        return this.apparatusPanel;
    }

    public void updateGraphics(ClockEvent clockEvent) {
        super.updateGraphics(clockEvent);
        this.apparatusPanel.update(null, null);
    }

    public void reset() {
        this.earth.getPhotonSource().setProductionRate(0.01);
        this.earth.reset();
        this.sun.setProductionRate(GreenhouseConfig.defaultSunPhotonProductionRate);
        ArrayList arrayList = this.model.getPhotons();
        for (int i = 0; i < arrayList.size(); ++i) {
            Photon photon = (Photon)arrayList.get(i);
            this.model.photonAbsorbed(photon);
        }
        this.model.getPhotons().clear();
        this.sun.setProductionRate(GreenhouseConfig.defaultSunPhotonProductionRate);
        for (Photon photon : this.photonToGraphicsMap.keySet()) {
            PhotonGraphic photonGraphic = (PhotonGraphic)this.photonToGraphicsMap.get(photon);
            this.getApparatusPanel().removeGraphic(photonGraphic);
        }
        this.photonToGraphicsMap.clear();
        this.getGreenhouseClock().setDelay(30);
    }

    public Earth getEarth() {
        return this.earth;
    }

    protected Rectangle2D.Double getFinalModelBounds() {
        return this.modelBounds;
    }

    public void thermometerEnabled(boolean bl) {
        this.thermometerEnabled = bl;
        if (bl) {
            this.getApparatusPanel().addGraphic(this.thermometerGraphic, 0.0);
        } else {
            this.getApparatusPanel().removeGraphic(this.thermometerGraphic);
        }
    }

    public void setVisiblePhotonRatio(double d) {
        double d2 = 0.0;
        Iterator iterator = this.photonToGraphicsMap.keySet().iterator();
        while (iterator.hasNext()) {
            PhotonGraphic photonGraphic = (PhotonGraphic)this.photonToGraphicsMap.get(iterator.next());
            d2 += d;
            this.drawingCanvas.removeGraphic(photonGraphic);
            photonGraphic.setVisible(false);
            if (!(d2 >= 1.0)) continue;
            this.drawingCanvas.addGraphic(photonGraphic, GreenhouseConfig.SUNLIGHT_PHOTON_GRAPHIC_LAYER);
            photonGraphic.setVisible(true);
            d2 = 0.0;
        }
        this.invisiblePhotonCnt = (int)(1.0 / d);
        this.earthPhotonEmitterListener.setInvisiblePhotonCnt((int)(1.0 / d));
        this.sunPhotonEmitterListener.setInvisiblePhotonCnt((int)(1.0 / d));
    }

    public void removeScatterEvent(ScatterEvent scatterEvent) {
        this.model.removeModelElement(scatterEvent);
        ScatterEventGraphic scatterEventGraphic = (ScatterEventGraphic)this.scatterToGraphicMap.get(scatterEvent);
        this.getApparatusPanel().removeGraphic(scatterEventGraphic);
        this.scatterToGraphicMap.remove(scatterEvent);
    }

    public void setVirginEarth() {
        this.earthGraphic.setVirginEarth();
    }

    public void setIceAge() {
        this.earthGraphic.setIceAge();
    }

    public void setToday() {
        this.earthGraphic.setToday();
    }

    public void setPreIndRev() {
        this.earthGraphic.set1750();
    }

    public class ModuleScatterEventListener
    implements Atmosphere.ScatterEventListener {
        public void photonScatered(Photon photon) {
            if (BaseGreenhouseModule.this.photonToGraphicsMap.get(photon) != null) {
                ScatterEvent scatterEvent = new ScatterEvent(photon, BaseGreenhouseModule.this);
                BaseGreenhouseModule.this.model.addModelElement(scatterEvent);
            }
        }
    }

    protected class PhotonAbsorberListener
    implements PhotonAbsorber.Listener {
        protected PhotonAbsorberListener() {
        }

        public void photonAbsorbed(Photon photon) {
            PhotonGraphic photonGraphic = (PhotonGraphic)BaseGreenhouseModule.this.photonToGraphicsMap.get(photon);
            BaseGreenhouseModule.this.drawingCanvas.removeGraphic(photonGraphic);
            BaseGreenhouseModule.this.photonToGraphicsMap.remove(photon);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PhotonEmitterListener
    implements PhotonEmitter.Listener<Photon> {
        private final Filter1D irFilter = new IrFilter();
        private int n = 0;

        protected PhotonEmitterListener() {
        }

        public void setInvisiblePhotonCnt(int n) {
            BaseGreenhouseModule.this.invisiblePhotonCnt = n;
        }

        @Override
        public void photonEmitted(Photon photon) {
            ++this.n;
            PhotonGraphic photonGraphic = new PhotonGraphic(photon);
            BaseGreenhouseModule.this.photonToGraphicsMap.put(photon, photonGraphic);
            photonGraphic.setVisible(false);
            if (this.n >= BaseGreenhouseModule.this.invisiblePhotonCnt) {
                photonGraphic.setVisible(true);
                double d = this.irFilter.absorbs(photon.getWavelength()) ? GreenhouseConfig.IR_PHOTON_GRAPHIC_LAYER : GreenhouseConfig.SUNLIGHT_PHOTON_GRAPHIC_LAYER;
                BaseGreenhouseModule.this.drawingCanvas.addGraphic(photonGraphic, d);
                this.n = 0;
            }
        }
    }
}

