/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.photonabsorption.PhotonAbsorptionResources;
import edu.colorado.phet.common.photonabsorption.model.Photon;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class PhotonNode
extends PNode
implements Observer {
    private final PImage photonImage;
    private final Photon photon;
    private final ModelViewTransform2D mvt;
    private static final HashMap<Double, String> mapWavelengthToImageName = new HashMap<Double, String>(){
        {
            this.put(20.0, "microwave-photon.png");
            this.put(8.5E-7, "photon-660.png");
            this.put(5.8E-7, "thin2.png");
            this.put(1.0E-7, "photon-100.png");
        }
    };

    public PhotonNode(Photon photon, ModelViewTransform2D modelViewTransform2D) {
        this.photon = photon;
        this.photon.addObserver(this);
        this.mvt = modelViewTransform2D;
        assert (mapWavelengthToImageName.containsKey(photon.getWavelength()));
        this.photonImage = new PImage(PhotonAbsorptionResources.getImage(mapWavelengthToImageName.get(photon.getWavelength())));
        this.photonImage.setOffset(-this.photonImage.getFullBoundsReference().width / 2.0, -this.photonImage.getFullBoundsReference().height / 2.0);
        this.addChild(this.photonImage);
        this.updatePosition();
    }

    public void update(Observable observable, Object object) {
        this.updatePosition();
    }

    private void updatePosition() {
        this.setOffset(this.mvt.modelToViewDouble(this.photon.getLocation()));
    }
}

