/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.view;

import edu.colorado.phet.common.phetcommon.view.controls.IntensitySlider;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.photonabsorption.PhotonAbsorptionResources;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhotonEmitterNode
extends PNode {
    private static int SLIDER_RANGE = 100;
    private PImage photonEmitterImage;
    private final PhotonAbsorptionModel model;
    private final PNode emitterImageLayer;
    private final PNode emissionControlSliderLayer;
    private final double emitterImageWidth;
    private final IntensitySlider emissionRateControlSlider;

    public PhotonEmitterNode(double d, ModelViewTransform2D modelViewTransform2D, final PhotonAbsorptionModel photonAbsorptionModel) {
        this.model = photonAbsorptionModel;
        this.emitterImageWidth = d;
        photonAbsorptionModel.addListener(new PhotonAbsorptionModel.Adapter(){

            public void emittedPhotonWavelengthChanged() {
                PhotonEmitterNode.this.updateImage(PhotonEmitterNode.this.emitterImageWidth);
            }
        });
        this.emitterImageLayer = new PNode();
        this.addChild(this.emitterImageLayer);
        this.emissionControlSliderLayer = new PNode();
        this.addChild(this.emissionControlSliderLayer);
        this.updateImage(this.emitterImageWidth);
        Dimension dimension = new Dimension(100, 30);
        this.emissionRateControlSlider = new IntensitySlider(Color.RED, IntensitySlider.HORIZONTAL, dimension);
        this.emissionRateControlSlider.setMinimum(0);
        this.emissionRateControlSlider.setMaximum(SLIDER_RANGE);
        this.emissionRateControlSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (double)PhotonEmitterNode.this.emissionRateControlSlider.getValue() / (double)SLIDER_RANGE;
                if (d == 0.0) {
                    photonAbsorptionModel.setPhotonEmissionPeriod(Double.POSITIVE_INFINITY);
                } else if (photonAbsorptionModel.getPhotonTarget() == PhotonAbsorptionModel.PhotonTarget.CONFIGURABLE_ATMOSPHERE) {
                    photonAbsorptionModel.setPhotonEmissionPeriod(100.0 / d);
                } else {
                    photonAbsorptionModel.setPhotonEmissionPeriod(400.0 / d);
                }
            }
        });
        EmissionRateControlSliderNode emissionRateControlSliderNode = new EmissionRateControlSliderNode(photonAbsorptionModel);
        PBounds pBounds = this.photonEmitterImage.getFullBoundsReference();
        emissionRateControlSliderNode.setOffset(pBounds.getCenterX() - emissionRateControlSliderNode.getFullBoundsReference().getWidth() / 2.0, pBounds.getCenterY() - emissionRateControlSliderNode.getFullBoundsReference().getHeight() / 2.0);
        this.emissionControlSliderLayer.addChild(emissionRateControlSliderNode);
    }

    private void updateImage(double d) {
        this.emitterImageLayer.removeAllChildren();
        if (this.model.getEmittedPhotonWavelength() == 8.5E-7) {
            this.photonEmitterImage = new PImage(PhotonAbsorptionResources.getImage("heat-lamp.png"));
        } else if (this.model.getEmittedPhotonWavelength() == 5.8E-7) {
            this.photonEmitterImage = new PImage(PhotonAbsorptionResources.getImage("flashlight2.png"));
        } else if (this.model.getEmittedPhotonWavelength() == 1.0E-7) {
            this.photonEmitterImage = new PImage(PhotonAbsorptionResources.getImage("uv_light_2.png"));
        } else if (this.model.getEmittedPhotonWavelength() == 20.0) {
            this.photonEmitterImage = new PImage(PhotonAbsorptionResources.getImage("microwave-transmitter.png"));
        }
        this.photonEmitterImage.scale(d / this.photonEmitterImage.getFullBoundsReference().width);
        this.photonEmitterImage.setOffset(-d, -this.photonEmitterImage.getFullBoundsReference().height / 2.0);
        this.emitterImageLayer.addChild(this.photonEmitterImage);
    }

    private static class EmissionRateControlSliderNode
    extends PNode {
        private final PhotonAbsorptionModel model;
        private final IntensitySlider emissionRateControlSlider;

        public EmissionRateControlSliderNode(final PhotonAbsorptionModel photonAbsorptionModel) {
            this.model = photonAbsorptionModel;
            this.model.addListener(new PhotonAbsorptionModel.Adapter(){

                public void emittedPhotonWavelengthChanged() {
                    EmissionRateControlSliderNode.this.update();
                }

                public void photonEmissionPeriodChanged() {
                    EmissionRateControlSliderNode.this.update();
                }
            });
            Dimension dimension = new Dimension(100, 30);
            this.emissionRateControlSlider = new IntensitySlider(Color.RED, IntensitySlider.HORIZONTAL, dimension){
                {
                    super(color, n, dimension);
                    this.setMinimum(0);
                    this.setMaximum(SLIDER_RANGE);
                    this.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            double d = (double)EmissionRateControlSliderNode.this.emissionRateControlSlider.getValue() / (double)SLIDER_RANGE;
                            if (d == 0.0) {
                                photonAbsorptionModel.setPhotonEmissionPeriod(Double.POSITIVE_INFINITY);
                            } else if (photonAbsorptionModel.getPhotonTarget() == PhotonAbsorptionModel.PhotonTarget.CONFIGURABLE_ATMOSPHERE) {
                                photonAbsorptionModel.setPhotonEmissionPeriod(100.0 / d);
                            } else {
                                photonAbsorptionModel.setPhotonEmissionPeriod(400.0 / d);
                            }
                        }
                    });
                }
            };
            PSwing pSwing = new PSwing(this.emissionRateControlSlider);
            this.addChild(pSwing);
        }

        private void update() {
            int n = this.model.getPhotonTarget() == PhotonAbsorptionModel.PhotonTarget.CONFIGURABLE_ATMOSPHERE ? (int)Math.round(100.0 / this.model.getPhotonEmissionPeriod() * (double)SLIDER_RANGE) : (int)Math.round(400.0 / this.model.getPhotonEmissionPeriod() * (double)SLIDER_RANGE);
            this.emissionRateControlSlider.setValue(n);
            if (this.model.getEmittedPhotonWavelength() == 8.5E-7) {
                this.emissionRateControlSlider.setColor(Color.RED);
            } else if (this.model.getEmittedPhotonWavelength() == 5.8E-7) {
                this.emissionRateControlSlider.setColor(Color.YELLOW);
            } else if (this.model.getEmittedPhotonWavelength() == 1.0E-7) {
                this.emissionRateControlSlider.setColor(new Color(200, 0, 200));
            } else if (this.model.getEmittedPhotonWavelength() == 20.0) {
                this.emissionRateControlSlider.setColor(new Color(200, 200, 200));
            } else {
                System.err.println(this.getClass().getName() + "- Error: Unrecognized photon.");
            }
        }
    }
}

