/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.atoms.Atom;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.view.AtomNode;
import edu.colorado.phet.common.photonabsorption.view.AtomicBondNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class MoleculeNode
extends PNode {
    private final PNode atomLayer;
    private final PNode bondLayer = new PNode();

    public MoleculeNode(Molecule molecule, ModelViewTransform2D modelViewTransform2D) {
        this.addChild(this.bondLayer);
        this.atomLayer = new PNode();
        this.addChild(this.atomLayer);
        for (Atom simpleObservable : molecule.getAtoms()) {
            this.atomLayer.addChild(new AtomNode(simpleObservable, modelViewTransform2D));
        }
        for (AtomicBond atomicBond : molecule.getAtomicBonds()) {
            this.bondLayer.addChild(new AtomicBondNode(atomicBond, modelViewTransform2D));
        }
        Molecule.Adapter adapter = new Molecule.Adapter(){

            public void electronicEnergyStateChanged(Molecule molecule) {
                super.electronicEnergyStateChanged(molecule);
                for (int i = 0; i < MoleculeNode.this.atomLayer.getChildrenCount(); ++i) {
                    AtomNode atomNode = (AtomNode)MoleculeNode.this.atomLayer.getChild(i);
                    atomNode.setHighlighted(molecule.isHighElectronicEnergyState());
                }
            }
        };
        molecule.addListener(adapter);
        adapter.electronicEnergyStateChanged(molecule);
    }

    public BufferedImage getImage() {
        Image image = this.toImage();
        assert (image instanceof BufferedImage);
        if (image instanceof BufferedImage) {
            return (BufferedImage)this.toImage();
        }
        return null;
    }
}

