/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class AtomicBondNode
extends PNode {
    private static double BOND_WIDTH_PROPORTION_SINGLE = 0.45;
    private static double BOND_WIDTH_PROPORTION_DOUBLE = 0.28;
    private static double BOND_WIDTH_PROPORTION_TRIPLE = 0.24;
    private static Color BOND_COLOR = new Color(0, 200, 0);
    private final AtomicBond atomicBond;
    private final ModelViewTransform2D mvt;
    private final double averageAtomRadius;

    public AtomicBondNode(AtomicBond atomicBond, ModelViewTransform2D modelViewTransform2D) {
        assert (atomicBond.getBondCount() > 0 && atomicBond.getBondCount() <= 3);
        this.atomicBond = atomicBond;
        this.mvt = modelViewTransform2D;
        atomicBond.addObserver(new SimpleObserver(){

            public void update() {
                AtomicBondNode.this.updateRepresentation();
            }
        });
        this.averageAtomRadius = modelViewTransform2D.modelToViewDifferentialXDouble((atomicBond.getAtom1().getRadius() + atomicBond.getAtom2().getRadius()) / 2.0);
        this.updateRepresentation();
    }

    private void updateRepresentation() {
        this.removeAllChildren();
        switch (this.atomicBond.getBondCount()) {
            case 1: {
                Point2D point2D = this.mvt.modelToViewDouble(this.atomicBond.getAtom1().getPositionRef());
                Point2D point2D2 = this.mvt.modelToViewDouble(this.atomicBond.getAtom2().getPositionRef());
                float f = (float)(BOND_WIDTH_PROPORTION_SINGLE * this.averageAtomRadius);
                PhetPPath phetPPath = new PhetPPath(new BasicStroke(f), (Paint)BOND_COLOR);
                phetPPath.setPathTo(new Line2D.Double(point2D, point2D2));
                this.addChild(phetPPath);
                break;
            }
            case 2: {
                final double d = this.mvt.modelToViewDifferentialXDouble(Math.min(this.atomicBond.getAtom1().getRadius(), this.atomicBond.getAtom2().getRadius()));
                Point2D point2D = this.mvt.modelToViewDouble(this.atomicBond.getAtom1().getPositionRef());
                Point2D point2D3 = this.mvt.modelToViewDouble(this.atomicBond.getAtom2().getPositionRef());
                final double d2 = Math.atan2(point2D.getX() - point2D3.getX(), point2D.getY() - point2D3.getY());
                Vector2D vector2D = new Vector2D(){
                    {
                        this.setMagnitude(d / 3.0);
                        this.setAngle(d2);
                    }
                };
                BasicStroke basicStroke = new BasicStroke((float)(BOND_WIDTH_PROPORTION_DOUBLE * this.averageAtomRadius));
                PhetPPath phetPPath = new PhetPPath(basicStroke, (Paint)BOND_COLOR);
                phetPPath.setPathTo(new Line2D.Double(point2D.getX() + vector2D.getX(), point2D.getY() - vector2D.getY(), point2D3.getX() + vector2D.getX(), point2D3.getY() - vector2D.getY()));
                vector2D.rotate(Math.PI);
                PhetPPath phetPPath2 = new PhetPPath(basicStroke, (Paint)BOND_COLOR);
                phetPPath2.setPathTo(new Line2D.Double(point2D.getX() + vector2D.getX(), point2D.getY() - vector2D.getY(), point2D3.getX() + vector2D.getX(), point2D3.getY() - vector2D.getY()));
                this.addChild(phetPPath);
                this.addChild(phetPPath2);
                break;
            }
            case 3: {
                final double d = this.mvt.modelToViewDifferentialXDouble(Math.min(this.atomicBond.getAtom1().getRadius(), this.atomicBond.getAtom2().getRadius()));
                Point2D point2D = this.mvt.modelToViewDouble(this.atomicBond.getAtom1().getPositionRef());
                Point2D point2D4 = this.mvt.modelToViewDouble(this.atomicBond.getAtom2().getPositionRef());
                final double d3 = Math.atan2(point2D.getX() - point2D4.getX(), point2D.getY() - point2D4.getY());
                Vector2D vector2D = new Vector2D(){
                    {
                        this.setMagnitude(d * 0.6);
                        this.setAngle(d3);
                    }
                };
                BasicStroke basicStroke = new BasicStroke((float)(BOND_WIDTH_PROPORTION_TRIPLE * this.averageAtomRadius));
                PhetPPath phetPPath = new PhetPPath(basicStroke, (Paint)BOND_COLOR);
                phetPPath.setPathTo(new Line2D.Double(point2D, point2D4));
                PhetPPath phetPPath3 = new PhetPPath(basicStroke, (Paint)BOND_COLOR);
                phetPPath3.setPathTo(new Line2D.Double(point2D.getX() + vector2D.getX(), point2D.getY() - vector2D.getY(), point2D4.getX() + vector2D.getX(), point2D4.getY() - vector2D.getY()));
                vector2D.rotate(Math.PI);
                PhetPPath phetPPath4 = new PhetPPath(basicStroke, (Paint)BOND_COLOR);
                phetPPath4.setPathTo(new Line2D.Double(point2D.getX() + vector2D.getX(), point2D.getY() - vector2D.getY(), point2D4.getX() + vector2D.getX(), point2D4.getY() - vector2D.getY()));
                this.addChild(phetPPath);
                this.addChild(phetPPath3);
                this.addChild(phetPPath4);
                break;
            }
            default: {
                System.err.println(this.getClass().getName() + " - Error: Can't represent bond number, value = " + this.atomicBond.getBondCount());
                assert (false);
                break;
            }
        }
    }
}

