/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.molecules;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.MoleculeID;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.atoms.NitrogenAtom;
import edu.colorado.phet.common.photonabsorption.model.atoms.OxygenAtom;
import java.awt.geom.Point2D;

public class N2O
extends Molecule {
    private final NitrogenAtom sideNitrogenAtom = new NitrogenAtom();
    private final NitrogenAtom centerNitrogenAtom = new NitrogenAtom();
    private final OxygenAtom oxygenAtom = new OxygenAtom();
    private final AtomicBond nitrogenNitrogenBond = new AtomicBond(this.sideNitrogenAtom, this.centerNitrogenAtom, 2);
    private final AtomicBond nitrogenOxygenBond = new AtomicBond(this.centerNitrogenAtom, this.oxygenAtom, 2);

    public N2O(Point2D point2D) {
        this.addAtom(this.sideNitrogenAtom);
        this.addAtom(this.centerNitrogenAtom);
        this.addAtom(this.oxygenAtom);
        this.addAtomicBond(this.nitrogenNitrogenBond);
        this.addAtomicBond(this.nitrogenOxygenBond);
        this.setPhotonAbsorptionStrategy(8.5E-7, new PhotonAbsorptionStrategy.VibrationStrategy(this));
        this.initializeAtomOffsets();
        this.setCenterOfGravityPos(point2D);
    }

    public N2O() {
        this(new Point2D.Double(0.0, 0.0));
    }

    protected void initializeAtomOffsets() {
        this.initialAtomCogOffsets.put(this.centerNitrogenAtom, new Vector2D(0.0, 0.0));
        this.initialAtomCogOffsets.put(this.sideNitrogenAtom, new Vector2D(-170.0, 0.0));
        this.initialAtomCogOffsets.put(this.oxygenAtom, new Vector2D(170.0, 0.0));
        this.updateAtomPositions();
    }

    public void setVibration(double d) {
        super.setVibration(d);
        double d2 = Math.sin(d);
        this.initialAtomCogOffsets.put(this.centerNitrogenAtom, new Vector2D(0.0, d2 * 50.0));
        this.initialAtomCogOffsets.put(this.sideNitrogenAtom, new Vector2D(-170.0, -d2 * 25.0));
        this.initialAtomCogOffsets.put(this.oxygenAtom, new Vector2D(170.0, -d2 * 25.0));
        this.updateAtomPositions();
    }

    public MoleculeID getMoleculeID() {
        return MoleculeID.N2O;
    }
}

