/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model.molecules;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.photonabsorption.model.Molecule;
import edu.colorado.phet.common.photonabsorption.model.MoleculeID;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.atoms.CarbonAtom;
import edu.colorado.phet.common.photonabsorption.model.atoms.HydrogenAtom;
import java.awt.geom.Point2D;

public class CH4
extends Molecule {
    private static final double ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE = 170.0 * Math.sin(0.7853981633974483);
    private static final double HYDROGEN_VIBRATION_DISTANCE_X = 30.0 * Math.cos(0.7853981633974483);
    private static final double HYDROGEN_VIBRATION_DISTANCE_Y = 30.0 * Math.sin(0.7853981633974483);
    private final CarbonAtom carbonAtom = new CarbonAtom();
    private final HydrogenAtom hydrogenAtom1 = new HydrogenAtom();
    private final HydrogenAtom hydrogenAtom2 = new HydrogenAtom();
    private final HydrogenAtom hydrogenAtom3 = new HydrogenAtom();
    private final HydrogenAtom hydrogenAtom4 = new HydrogenAtom();
    private final AtomicBond carbonHydrogenBond1 = new AtomicBond(this.carbonAtom, this.hydrogenAtom1, 1);
    private final AtomicBond carbonHydrogenBond2 = new AtomicBond(this.carbonAtom, this.hydrogenAtom2, 1);
    private final AtomicBond carbonHydrogenBond3 = new AtomicBond(this.carbonAtom, this.hydrogenAtom3, 1);
    private final AtomicBond carbonHydrogenBond4 = new AtomicBond(this.carbonAtom, this.hydrogenAtom4, 1);

    public CH4(Point2D point2D) {
        this.addAtom(this.carbonAtom);
        this.addAtom(this.hydrogenAtom1);
        this.addAtom(this.hydrogenAtom2);
        this.addAtom(this.hydrogenAtom3);
        this.addAtom(this.hydrogenAtom4);
        this.addAtomicBond(this.carbonHydrogenBond1);
        this.addAtomicBond(this.carbonHydrogenBond2);
        this.addAtomicBond(this.carbonHydrogenBond3);
        this.addAtomicBond(this.carbonHydrogenBond4);
        this.setPhotonAbsorptionStrategy(8.5E-7, new PhotonAbsorptionStrategy.VibrationStrategy(this));
        this.initializeAtomOffsets();
        this.setCenterOfGravityPos(point2D);
    }

    public CH4() {
        this(new Point2D.Double(0.0, 0.0));
    }

    protected void initializeAtomOffsets() {
        this.initialAtomCogOffsets.put(this.carbonAtom, new Vector2D(0.0, 0.0));
        this.initialAtomCogOffsets.put(this.hydrogenAtom1, new Vector2D(-ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE, ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE));
        this.initialAtomCogOffsets.put(this.hydrogenAtom2, new Vector2D(ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE, ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE));
        this.initialAtomCogOffsets.put(this.hydrogenAtom3, new Vector2D(ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE, -ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE));
        this.initialAtomCogOffsets.put(this.hydrogenAtom4, new Vector2D(-ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE, -ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE));
        this.updateAtomPositions();
    }

    public void setVibration(double d) {
        super.setVibration(d);
        if (d != 0.0) {
            double d2 = Math.sin(d);
            this.initialAtomCogOffsets.put(this.hydrogenAtom1, new Vector2D(-ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE + d2 * HYDROGEN_VIBRATION_DISTANCE_X, ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE + d2 * HYDROGEN_VIBRATION_DISTANCE_Y));
            this.initialAtomCogOffsets.put(this.hydrogenAtom2, new Vector2D(ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE - d2 * HYDROGEN_VIBRATION_DISTANCE_X, ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE + d2 * HYDROGEN_VIBRATION_DISTANCE_Y));
            this.initialAtomCogOffsets.put(this.hydrogenAtom3, new Vector2D(-ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE - d2 * HYDROGEN_VIBRATION_DISTANCE_X, -ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE + d2 * HYDROGEN_VIBRATION_DISTANCE_Y));
            this.initialAtomCogOffsets.put(this.hydrogenAtom4, new Vector2D(ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE + d2 * HYDROGEN_VIBRATION_DISTANCE_X, -ROTATED_INITIAL_CARBON_HYDROGEN_DISTANCE + d2 * HYDROGEN_VIBRATION_DISTANCE_Y));
            double d3 = -0.0832570144034635 * (((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom1)).getX() + ((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom2)).getX() + ((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom3)).getX() + ((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom4)).getX());
            double d4 = -0.0832570144034635 * (((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom1)).getY() + ((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom2)).getY() + ((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom3)).getY() + ((Vector2D)this.initialAtomCogOffsets.get(this.hydrogenAtom4)).getY());
            this.initialAtomCogOffsets.put(this.carbonAtom, new Vector2D(d3, d4));
        } else {
            this.initializeAtomOffsets();
        }
        this.updateAtomPositions();
    }

    public MoleculeID getMoleculeID() {
        return MoleculeID.CH4;
    }
}

