/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model;

import edu.colorado.phet.common.photonabsorption.model.PhotonEmitter;
import java.awt.geom.Point2D;
import java.util.Observable;

public class Photon
extends Observable {
    private double wavelength;
    private PhotonEmitter source;
    private Point2D.Double location = new Point2D.Double();
    private double radius = 0.1;
    private float vx;
    private float vy;

    public Photon(double d, PhotonEmitter photonEmitter) {
        this.wavelength = d;
        this.source = photonEmitter;
    }

    public void setVelocity(float f, float f2) {
        this.vx = f;
        this.vy = f2;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public void setLocation(double d, double d2) {
        this.location.setLocation(d, d2);
        this.setChanged();
        this.notifyObservers();
    }

    public void stepInTime(double d) {
        this.setLocation(this.location.x + (double)this.vx * d, this.location.y + (double)this.vy * d);
    }
}

