/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.photonabsorption.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.photonabsorption.model.MoleculeID;
import edu.colorado.phet.common.photonabsorption.model.Photon;
import edu.colorado.phet.common.photonabsorption.model.PhotonAbsorptionStrategy;
import edu.colorado.phet.common.photonabsorption.model.atoms.Atom;
import edu.colorado.phet.common.photonabsorption.model.atoms.AtomicBond;
import edu.colorado.phet.common.photonabsorption.model.molecules.CH4;
import edu.colorado.phet.common.photonabsorption.model.molecules.CO2;
import edu.colorado.phet.common.photonabsorption.model.molecules.H2O;
import edu.colorado.phet.common.photonabsorption.model.molecules.N2;
import edu.colorado.phet.common.photonabsorption.model.molecules.N2O;
import edu.colorado.phet.common.photonabsorption.model.molecules.O;
import edu.colorado.phet.common.photonabsorption.model.molecules.O2;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Molecule {
    private static final Random RAND = new Random();
    protected final ArrayList<Atom> atoms = new ArrayList();
    protected final ArrayList<AtomicBond> atomicBonds = new ArrayList();
    private final Point2D centerOfGravity = new Point2D.Double();
    protected final HashMap<Atom, Vector2D> initialAtomCogOffsets = new HashMap();
    protected final HashMap<Atom, Vector2D> vibrationAtomOffsets = new HashMap();
    protected final ArrayList<Listener> listeners = new ArrayList();
    private final Vector2D velocity = new Vector2D(0.0, 0.0);
    private final HashMap<Double, PhotonAbsorptionStrategy> mapWavelengthToAbsorptionStrategy = new HashMap();
    private PhotonAbsorptionStrategy activePhotonAbsorptionStrategy = new PhotonAbsorptionStrategy.NullPhotonAbsorptionStrategy(this);
    private double absorbtionHysteresisCountdownTime = 0.0;
    private final ArrayList<Photon> passThroughPhotonList = new ArrayList(10);
    private double currentVibrationRadians = 0.0;
    private double currentRotationRadians = 0.0;
    private boolean highElectronicEnergyState = false;
    private boolean vibrating = false;
    private boolean rotating = false;
    private boolean rotationDirectionClockwise = true;
    protected final ArrayList<Molecule> constituentMolecules = new ArrayList();

    protected void setPhotonAbsorptionStrategy(double d, PhotonAbsorptionStrategy photonAbsorptionStrategy) {
        this.mapWavelengthToAbsorptionStrategy.put(d, photonAbsorptionStrategy);
    }

    protected boolean isPhotonAbsorbed() {
        return !(this.activePhotonAbsorptionStrategy instanceof PhotonAbsorptionStrategy.NullPhotonAbsorptionStrategy);
    }

    public abstract MoleculeID getMoleculeID();

    public static Molecule createMolecule(MoleculeID moleculeID) {
        Molecule molecule = null;
        switch (moleculeID) {
            case CH4: {
                molecule = new CH4();
                break;
            }
            case CO2: {
                molecule = new CO2();
                break;
            }
            case H2O: {
                molecule = new H2O();
                break;
            }
            case N2: {
                molecule = new N2();
                break;
            }
            case N2O: {
                molecule = new N2O();
                break;
            }
            case O: {
                molecule = new O();
                break;
            }
            case O2: {
                molecule = new O2();
                break;
            }
            default: {
                System.err.println("Molecule:  - Error: Unrecognized molecule type.");
                assert (false);
                break;
            }
        }
        return molecule;
    }

    public void stepInTime(double d) {
        this.activePhotonAbsorptionStrategy.stepInTime(d);
        if (this.absorbtionHysteresisCountdownTime >= 0.0) {
            this.absorbtionHysteresisCountdownTime -= d;
        }
        if (this.vibrating) {
            this.advanceVibration(d * 5.0 / 1000.0 * 2.0 * Math.PI);
        }
        if (this.rotating) {
            int n = this.rotationDirectionClockwise ? -1 : 1;
            this.rotate(d * 1.1 / 1000.0 * 2.0 * Math.PI * (double)n);
        }
        this.setCenterOfGravityPos(this.velocity.getDestination(this.centerOfGravity));
        this.setCenterOfGravityPos(this.centerOfGravity.getX() + this.velocity.getX() * d, this.centerOfGravity.getY() + this.velocity.getY() * d);
    }

    public void reset() {
        this.activePhotonAbsorptionStrategy.reset();
        this.activePhotonAbsorptionStrategy = new PhotonAbsorptionStrategy.NullPhotonAbsorptionStrategy(this);
        this.absorbtionHysteresisCountdownTime = 0.0;
        this.setVibrating(false);
        this.setVibration(0.0);
        this.setRotating(false);
        this.setRotation(0.0);
    }

    public void setVibrating(boolean bl) {
        this.vibrating = bl;
    }

    public void setRotating(boolean bl) {
        this.rotating = bl;
    }

    public void setRotationDirectionClockwise(boolean bl) {
        this.rotationDirectionClockwise = bl;
    }

    public void addListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public Point2D getCenterOfGravityPos() {
        return new Point2D.Double(this.centerOfGravity.getX(), this.centerOfGravity.getY());
    }

    protected Point2D getCenterOfGravityPosRef() {
        return this.centerOfGravity;
    }

    public void setCenterOfGravityPos(double d, double d2) {
        if (this.centerOfGravity.getX() != d || this.centerOfGravity.getY() != d2) {
            this.centerOfGravity.setLocation(d, d2);
            this.updateAtomPositions();
            this.notifyCenterOfGravityPosChanged();
        }
    }

    public void setCenterOfGravityPos(Point2D point2D) {
        this.setCenterOfGravityPos(point2D.getX(), point2D.getY());
    }

    public void setVibration(double d) {
        this.currentVibrationRadians = d;
    }

    public void advanceVibration(double d) {
        this.currentVibrationRadians += d;
        this.setVibration(this.currentVibrationRadians);
    }

    public void rotate(double d) {
        this.setRotation((this.currentRotationRadians + d) % (Math.PI * 2));
    }

    public void setRotation(double d) {
        if (d != this.currentRotationRadians) {
            this.currentRotationRadians = d;
            this.updateAtomPositions();
        }
    }

    public void setHighElectronicEnergyState(boolean bl) {
        this.highElectronicEnergyState = bl;
        this.notifyElectronicEnergyStateChanged();
    }

    private void notifyElectronicEnergyStateChanged() {
        for (Listener listener : this.listeners) {
            listener.electronicEnergyStateChanged(this);
        }
    }

    private void notifyCenterOfGravityPosChanged() {
        for (Listener listener : this.listeners) {
            listener.centerOfGravityPosChanged(this);
        }
    }

    public boolean isHighElectronicEnergyState() {
        return this.highElectronicEnergyState;
    }

    public void breakApart() {
        System.err.println(this.getClass().getName() + " - Error: breakApart invoked on a molecule for which the action is not implemented.");
        assert (false);
    }

    protected void markPhotonForPassThrough(Photon photon) {
        if (this.passThroughPhotonList.size() >= 10) {
            this.passThroughPhotonList.remove(0);
        }
        this.passThroughPhotonList.add(photon);
    }

    protected boolean isPhotonMarkedForPassThrough(Photon photon) {
        return this.passThroughPhotonList.contains(photon);
    }

    public ArrayList<Atom> getAtoms() {
        return new ArrayList<Atom>(this.atoms);
    }

    public ArrayList<AtomicBond> getAtomicBonds() {
        return new ArrayList<AtomicBond>(this.atomicBonds);
    }

    public boolean queryAbsorbPhoton(Photon photon) {
        PhotonAbsorptionStrategy photonAbsorptionStrategy;
        boolean bl = false;
        if (!this.isPhotonAbsorbed() && this.absorbtionHysteresisCountdownTime <= 0.0 && photon.getLocation().distance(this.getCenterOfGravityPos()) < 100.0 && !this.isPhotonMarkedForPassThrough(photon) && (photonAbsorptionStrategy = this.mapWavelengthToAbsorptionStrategy.get(photon.getWavelength())) != null) {
            if (photonAbsorptionStrategy.queryAndAbsorbPhoton(photon)) {
                bl = true;
                this.activePhotonAbsorptionStrategy = photonAbsorptionStrategy;
                this.activePhotonAbsorptionStrategy.queryAndAbsorbPhoton(photon);
            } else {
                this.markPhotonForPassThrough(photon);
            }
        }
        return bl;
    }

    public void setActiveStrategy(PhotonAbsorptionStrategy photonAbsorptionStrategy) {
        this.activePhotonAbsorptionStrategy = photonAbsorptionStrategy;
    }

    protected void addAtom(Atom atom) {
        this.atoms.add(atom);
        this.initialAtomCogOffsets.put(atom, new Vector2D(0.0, 0.0));
        this.vibrationAtomOffsets.put(atom, new Vector2D(0.0, 0.0));
    }

    protected void addAtomicBond(AtomicBond atomicBond) {
        this.atomicBonds.add(atomicBond);
    }

    public void emitPhoton(double d) {
        this.emitPhoton(new Photon(d, null));
    }

    protected void emitPhoton(Photon photon) {
        double d = RAND.nextDouble() * Math.PI * 2.0;
        photon.setVelocity((float)(2.0 * Math.cos(d)), (float)(2.0 * Math.sin(d)));
        Point2D point2D = this.getCenterOfGravityPosRef();
        photon.setLocation(point2D.getX(), point2D.getY());
        this.notifyPhotonEmitted(photon);
        this.absorbtionHysteresisCountdownTime = 200.0;
    }

    private void notifyPhotonEmitted(Photon photon) {
        for (Listener listener : this.listeners) {
            listener.photonEmitted(photon);
        }
    }

    protected void updateAtomPositions() {
        for (Atom atom : this.initialAtomCogOffsets.keySet()) {
            Vector2D vector2D = new Vector2D(this.initialAtomCogOffsets.get(atom));
            vector2D.add(this.vibrationAtomOffsets.get(atom));
            vector2D.rotate(this.currentRotationRadians);
            atom.setPosition(this.centerOfGravity.getX() + vector2D.getX(), this.centerOfGravity.getY() + vector2D.getY());
        }
    }

    public void setVelocity(double d, double d2) {
        this.setVelocity(new ImmutableVector2D(d, d2));
    }

    public void setVelocity(ImmutableVector2D immutableVector2D) {
        this.velocity.setValue(immutableVector2D);
    }

    public Rectangle2D getBoundingRect() {
        Rectangle2D[] rectangle2DArray = new Rectangle2D[this.atoms.size()];
        for (int i = 0; i < this.atoms.size(); ++i) {
            rectangle2DArray[i] = this.atoms.get(i).getBoundingRect();
        }
        return RectangleUtils.union(rectangle2DArray);
    }

    public ArrayList<Molecule> getBreakApartConstituents() {
        return this.constituentMolecules;
    }

    public static class Adapter
    implements Listener {
        public void photonEmitted(Photon photon) {
        }

        public void brokeApart(Molecule molecule) {
        }

        public void electronicEnergyStateChanged(Molecule molecule) {
        }

        public void centerOfGravityPosChanged(Molecule molecule) {
        }
    }

    public static interface Listener {
        public void photonEmitted(Photon var1);

        public void brokeApart(Molecule var1);

        public void electronicEnergyStateChanged(Molecule var1);

        public void centerOfGravityPosChanged(Molecule var1);
    }
}

