/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.Color;

public class ColorUtils {
    private ColorUtils() {
    }

    public static Color brighterColor(Color color, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("factor must be between 0 and 1: " + d);
        }
        int n = Math.min(255, color.getRed() + (int)(d * (double)(255 - color.getRed())));
        int n2 = Math.min(255, color.getGreen() + (int)(d * (double)(255 - color.getGreen())));
        int n3 = Math.min(255, color.getBlue() + (int)(d * (double)(255 - color.getBlue())));
        return new Color(n, n2, n3);
    }

    public static Color darkerColor(Color color, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("factor must be between 0 and 1: " + d);
        }
        int n = Math.max(0, color.getRed() - (int)(d * (double)color.getRed()));
        int n2 = Math.max(0, color.getGreen() - (int)(d * (double)color.getGreen()));
        int n3 = Math.max(0, color.getBlue() - (int)(d * (double)color.getBlue()));
        return new Color(n, n2, n3);
    }
}

