/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.mechanics;

import edu.colorado.phet.common.mechanics.PhysicalVector;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import java.util.Vector;

public class Vector3D
extends PhysicalVector {
    public Vector3D() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3D(Vector2D vector2D) {
        this(vector2D.getX(), vector2D.getY(), 0.0);
    }

    public Vector3D(double d, double d2, double d3) {
        super(3);
        this.setX(d);
        this.setY(d2);
        this.setZ(d3);
        if (Double.isNaN(d)) {
            System.out.println("Vector2D constructor: x was NaN");
        }
        if (Double.isNaN(d2)) {
            System.out.println("Vector2D constructor: y was NaN");
        }
    }

    public String toString() {
        Vector<Double> vector = new Vector<Double>();
        vector.add(new Double(this.getX()));
        vector.add(new Double(this.getY()));
        vector.add(new Double(this.getZ()));
        return vector.toString();
    }

    public Vector3D setComponents(double d, double d2, double d3) {
        this.setX(d);
        this.setY(d2);
        this.setZ(d3);
        return this;
    }

    public double getX() {
        return this.getScalarAt(0);
    }

    public void setX(double d) {
        this.setScalarAt(0, d);
    }

    public double getY() {
        return this.getScalarAt(1);
    }

    public void setY(double d) {
        this.setScalarAt(1, d);
    }

    public double getZ() {
        return this.getScalarAt(2);
    }

    public void setZ(double d) {
        this.setScalarAt(2, d);
    }

    public Vector3D add(Vector3D vector3D) {
        return (Vector3D)super.add(vector3D, this);
    }

    public Vector3D multiply(double d) {
        return (Vector3D)super.multiply(d, this);
    }

    public Vector3D crossProduct(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D(this.getY() * vector3D.getZ() - this.getZ() * vector3D.getY(), -this.getX() * vector3D.getZ() + this.getZ() * vector3D.getX(), this.getX() * vector3D.getY() - this.getY() * vector3D.getX());
        return vector3D2;
    }
}

