/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.faraday.collision.CollisionDetector;
import edu.colorado.phet.faraday.collision.ICollidable;
import edu.colorado.phet.faraday.model.Lightbulb;
import edu.colorado.phet.faraday.model.PickupCoil;
import edu.colorado.phet.faraday.model.Voltmeter;
import edu.colorado.phet.faraday.view.CoilGraphic;
import edu.colorado.phet.faraday.view.FaradayMouseHandler;
import edu.colorado.phet.faraday.view.FluxDisplayGraphic;
import edu.colorado.phet.faraday.view.LightbulbGraphic;
import edu.colorado.phet.faraday.view.PickupCoilSamplePointsGraphic;
import edu.colorado.phet.faraday.view.VoltmeterGraphic;
import java.awt.Component;
import java.awt.Point;
import java.awt.Shape;

public class PickupCoilGraphic
extends GraphicLayerSet
implements SimpleObserver,
ApparatusPanel2.ChangeListener,
ICollidable {
    private PickupCoil _pickupCoilModel;
    private CoilGraphic _coilGraphic;
    private LightbulbGraphic _lightbulbGraphic;
    private VoltmeterGraphic _voltmeterGraphic;
    private CompositePhetGraphic _foreground;
    private CompositePhetGraphic _background;
    private CollisionDetector _collisionDetector;
    private FluxDisplayGraphic _fluxDisplayGraphic;
    private PickupCoilSamplePointsGraphic _samplePointsGraphic;
    private FaradayMouseHandler _mouseHandler;

    public PickupCoilGraphic(Component component, BaseModel baseModel, PickupCoil pickupCoil, Lightbulb lightbulb, Voltmeter voltmeter) {
        assert (component != null);
        assert (baseModel != null);
        assert (pickupCoil != null);
        assert (lightbulb != null);
        assert (voltmeter != null);
        this._pickupCoilModel = pickupCoil;
        this._pickupCoilModel.addObserver(this);
        this._collisionDetector = new CollisionDetector(this);
        this._coilGraphic = new CoilGraphic(component, pickupCoil, baseModel);
        this._coilGraphic.setEndsConnected(true);
        this._lightbulbGraphic = new LightbulbGraphic(component, lightbulb);
        this._voltmeterGraphic = new VoltmeterGraphic(component, voltmeter);
        this._foreground = new CompositePhetGraphic(component);
        this._foreground.addGraphic(this._coilGraphic.getForeground());
        this._foreground.addGraphic(this._lightbulbGraphic);
        this._foreground.addGraphic(this._voltmeterGraphic);
        this._background = new CompositePhetGraphic(component);
        this._background.addGraphic(this._coilGraphic.getBackground());
        this.setDraggingEnabled(true);
        this._samplePointsGraphic = new PickupCoilSamplePointsGraphic(component, pickupCoil);
        this._samplePointsGraphic.setVisible(false);
        this._foreground.addGraphic(this._samplePointsGraphic);
        this._fluxDisplayGraphic = new FluxDisplayGraphic(component, pickupCoil);
        this._fluxDisplayGraphic.setVisible(false);
        this._fluxDisplayGraphic.setLocation(75, -50);
        this._foreground.addGraphic(this._fluxDisplayGraphic);
        this.update();
    }

    public PhetGraphic getForeground() {
        return this._foreground;
    }

    public PhetGraphic getBackground() {
        return this._background;
    }

    public CoilGraphic getCoilGraphic() {
        return this._coilGraphic;
    }

    public LightbulbGraphic getLightbulbGraphic() {
        return this._lightbulbGraphic;
    }

    public void setDraggingEnabled(boolean bl) {
        this._foreground.setIgnoreMouse(!bl);
        this._background.setIgnoreMouse(!bl);
        if (bl) {
            this._mouseHandler = new FaradayMouseHandler(this._pickupCoilModel, this);
            this._mouseHandler.setCollisionDetector(this._collisionDetector);
            this._foreground.setCursorHand();
            this._foreground.addMouseInputListener(this._mouseHandler);
            this._background.setCursorHand();
            this._background.addMouseInputListener(this._mouseHandler);
        } else {
            this._foreground.removeAllMouseInputListeners();
            this._background.removeAllMouseInputListeners();
        }
    }

    public void setSamplePointsVisible(boolean bl) {
        this._samplePointsGraphic.setVisible(bl);
    }

    public boolean isSamplePointsVisible() {
        return this._samplePointsGraphic.isVisible();
    }

    public void setFluxDisplayVisible(boolean bl) {
        this._fluxDisplayGraphic.setVisible(bl);
    }

    public boolean isFluxDisplayVisible() {
        return this._fluxDisplayGraphic.isVisible();
    }

    public boolean contains(int n, int n2) {
        return this._foreground.contains(n, n2) || this._background.contains(n, n2);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public void update() {
        if (this._foreground.isVisible()) {
            this._foreground.setLocation((int)this._pickupCoilModel.getX(), (int)this._pickupCoilModel.getY());
            this._background.setLocation((int)this._pickupCoilModel.getX(), (int)this._pickupCoilModel.getY());
            this._foreground.clearTransform();
            this._background.clearTransform();
            int n = -10;
            int n2 = -(this._coilGraphic.getForeground().getHeight() / 2);
            this._lightbulbGraphic.setLocation(n, n2);
            this._voltmeterGraphic.setLocation(n + 5, n2 + 5);
            this._foreground.rotate(this._pickupCoilModel.getDirection());
            this._background.rotate(this._pickupCoilModel.getDirection());
            this._foreground.repaint();
            this._background.repaint();
        }
    }

    public CollisionDetector getCollisionDetector() {
        return this._collisionDetector;
    }

    public Shape[] getCollisionBounds() {
        return this._coilGraphic.getCollisionBounds();
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._mouseHandler.setDragBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
    }
}

