/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.faraday.collision.CollisionDetector;
import edu.colorado.phet.faraday.model.FaradayObservable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class FaradayMouseHandler
extends MouseInputAdapter {
    private FaradayObservable _modelComponent;
    private PhetGraphic _viewComponent;
    private boolean _dragEnabled;
    private Point _previousPoint;
    private Rectangle _dragBounds;
    private CollisionDetector _collisionDetector;

    public FaradayMouseHandler(FaradayObservable faradayObservable, PhetGraphic phetGraphic) {
        assert (faradayObservable != null);
        assert (phetGraphic != null);
        this._modelComponent = faradayObservable;
        this._viewComponent = phetGraphic;
        this._dragBounds = null;
        this._collisionDetector = null;
        this._dragEnabled = true;
        this._previousPoint = new Point();
    }

    public void setCollisionDetector(CollisionDetector collisionDetector) {
        this._collisionDetector = collisionDetector;
    }

    public void setDragBounds(int n, int n2, int n3, int n4) {
        if (this._dragBounds == null) {
            this._dragBounds = new Rectangle();
        }
        this._dragBounds.setBounds(n, n2, n3, n4);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._dragEnabled = true;
        this._previousPoint.setLocation(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._dragEnabled && this._viewComponent.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this._dragEnabled = true;
            this._previousPoint.setLocation(mouseEvent.getPoint());
        }
        if (this._dragEnabled) {
            int n = mouseEvent.getX() - this._previousPoint.x;
            int n2 = mouseEvent.getY() - this._previousPoint.y;
            boolean bl = false;
            if (this._dragBounds != null) {
                bl = !this._dragBounds.contains(mouseEvent.getPoint());
            }
            boolean bl2 = false;
            if (this._collisionDetector != null) {
                boolean bl3 = this._collisionDetector.collidesNow();
                boolean bl4 = this._collisionDetector.wouldCollide(n, n2);
                boolean bl5 = bl2 = !bl3 && bl4;
            }
            if (bl || bl2) {
                this._dragEnabled = false;
            } else {
                double d = this._modelComponent.getX() + (double)n;
                double d2 = this._modelComponent.getY() + (double)n2;
                this._modelComponent.setLocation(d, d2);
                this._previousPoint.setLocation(mouseEvent.getPoint());
            }
        }
    }
}

