/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.faraday.collision.CollisionDetector;
import edu.colorado.phet.faraday.collision.ICollidable;
import edu.colorado.phet.faraday.model.ACPowerSupply;
import edu.colorado.phet.faraday.model.Battery;
import edu.colorado.phet.faraday.model.Electromagnet;
import edu.colorado.phet.faraday.model.SourceCoil;
import edu.colorado.phet.faraday.view.ACPowerSupplyGraphic;
import edu.colorado.phet.faraday.view.BatteryGraphic;
import edu.colorado.phet.faraday.view.CoilGraphic;
import edu.colorado.phet.faraday.view.FaradayMouseHandler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;

public class ElectromagnetGraphic
extends GraphicLayerSet
implements SimpleObserver,
ApparatusPanel2.ChangeListener,
ICollidable {
    private Electromagnet _electromagnetModel;
    private CoilGraphic _coilGraphic;
    private BatteryGraphic _batteryGraphic;
    private ACPowerSupplyGraphic _acPowerSupplyGraphic;
    private GraphicLayerSet _foreground;
    private GraphicLayerSet _background;
    private CollisionDetector _collisionDetector;
    private PhetShapeGraphic _modelShapeGraphic;
    private FaradayMouseHandler _mouseHandler;

    public ElectromagnetGraphic(Component component, BaseModel baseModel, Electromagnet electromagnet, SourceCoil sourceCoil, Battery battery, ACPowerSupply aCPowerSupply) {
        assert (component != null);
        assert (baseModel != null);
        assert (electromagnet != null);
        this._electromagnetModel = electromagnet;
        this._electromagnetModel.addObserver(this);
        this._coilGraphic = new CoilGraphic(component, sourceCoil, baseModel);
        this._batteryGraphic = new BatteryGraphic(component, battery);
        this._acPowerSupplyGraphic = new ACPowerSupplyGraphic(component, aCPowerSupply);
        this._foreground = new GraphicLayerSet(component);
        this._foreground.addGraphic(this._coilGraphic.getForeground());
        this._foreground.addGraphic(this._batteryGraphic);
        this._foreground.addGraphic(this._acPowerSupplyGraphic);
        this._background = new GraphicLayerSet(component);
        this._background.addGraphic(this._coilGraphic.getBackground());
        this._modelShapeGraphic = new PhetShapeGraphic(component);
        this._modelShapeGraphic.setShape(this._electromagnetModel.getShape());
        this._modelShapeGraphic.setVisible(false);
        this._modelShapeGraphic.setBorderColor(Color.YELLOW);
        this._modelShapeGraphic.setStroke(new BasicStroke(1.0f));
        this._foreground.addGraphic(this._modelShapeGraphic);
        this._foreground.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._mouseHandler = new FaradayMouseHandler(this._electromagnetModel, this);
        this._collisionDetector = new CollisionDetector(this);
        this._mouseHandler.setCollisionDetector(this._collisionDetector);
        this._foreground.setCursorHand();
        this._foreground.addMouseInputListener(this._mouseHandler);
        this._background.setCursorHand();
        this._background.addMouseInputListener(this._mouseHandler);
        this.update();
    }

    public PhetGraphic getForeground() {
        return this._foreground;
    }

    public PhetGraphic getBackground() {
        return this._background;
    }

    public CoilGraphic getCoilGraphic() {
        return this._coilGraphic;
    }

    public void setModelShapeVisible(boolean bl) {
        this._modelShapeGraphic.setVisible(bl);
    }

    public boolean isModelShapeVisible() {
        return this._modelShapeGraphic.isVisible();
    }

    public boolean contains(int n, int n2) {
        return this._foreground.contains(n, n2) || this._background.contains(n, n2);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this._foreground.setVisible(bl);
        this._background.setVisible(bl);
        this.update();
    }

    public boolean isVisible() {
        return this._foreground.isVisible() || this._background.isVisible();
    }

    public void update() {
        if (this.isVisible()) {
            this._foreground.setLocation((int)this._electromagnetModel.getX(), (int)this._electromagnetModel.getY());
            this._background.setLocation((int)this._electromagnetModel.getX(), (int)this._electromagnetModel.getY());
            this._foreground.clearTransform();
            this._background.clearTransform();
            int n = 0;
            int n2 = -(this._coilGraphic.getForeground().getHeight() / 2) - 14;
            this._batteryGraphic.setLocation(n, n2);
            this._acPowerSupplyGraphic.setLocation(n, n2);
            this._foreground.repaint();
            this._background.repaint();
        }
    }

    public CollisionDetector getCollisionDetector() {
        return this._collisionDetector;
    }

    public Shape[] getCollisionBounds() {
        return this._coilGraphic.getCollisionBounds();
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._mouseHandler.setDragBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
    }
}

