/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.faraday.model.AbstractCoil;
import edu.colorado.phet.faraday.model.Electron;
import edu.colorado.phet.faraday.model.ElectronPathDescriptor;
import edu.colorado.phet.faraday.model.FaradayObservable;
import edu.colorado.phet.faraday.util.QuadBezierSpline;
import edu.colorado.phet.faraday.view.ElectronGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.ArrayList;

public class CoilGraphic
implements SimpleObserver {
    private static final Color FOREGROUND_COLOR = new Color(153, 102, 51);
    private static final Color MIDDLEGROUND_COLOR = new Color(92, 52, 12);
    private static final Color BACKGROUND_COLOR = new Color(40, 23, 3);
    private Component _component;
    private AbstractCoil _coilModel;
    private BaseModel _baseModel;
    private CompositePhetGraphic _foreground;
    private CompositePhetGraphic _background;
    private boolean _electronAnimationEnabled;
    private Color _foregroundColor;
    private Color _middlegroundColor;
    private Color _backgroundColor;
    private ArrayList<ElectronPathDescriptor> _electronPath;
    private ArrayList<Electron> _electrons;
    private int _numberOfLoops;
    private double _loopRadius;
    private double _wireWidth;
    private double _loopSpacing;
    private double _current;
    private Rectangle[] _collisionBounds;
    private double _electronSpeedScale;
    private boolean _endsConnected;

    public CoilGraphic(Component component, AbstractCoil abstractCoil, BaseModel baseModel) {
        assert (component != null);
        assert (abstractCoil != null);
        assert (baseModel != null);
        this._component = component;
        this._baseModel = baseModel;
        this._coilModel = abstractCoil;
        this._coilModel.addObserver(this);
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._foreground = new CompositePhetGraphic(this._component);
        this._background = new CompositePhetGraphic(this._component);
        this._foreground.setRenderingHints(renderingHints);
        this._background.setRenderingHints(renderingHints);
        this._electronAnimationEnabled = true;
        this._foregroundColor = FOREGROUND_COLOR;
        this._middlegroundColor = MIDDLEGROUND_COLOR;
        this._backgroundColor = BACKGROUND_COLOR;
        this._electronPath = new ArrayList();
        this._electrons = new ArrayList();
        this._numberOfLoops = -1;
        this._loopRadius = -1.0;
        this._wireWidth = -1.0;
        this._loopSpacing = -1.0;
        this._current = -1.0;
        this._electronSpeedScale = 1.0;
        this._endsConnected = false;
        this.update();
    }

    public PhetGraphic getForeground() {
        return this._foreground;
    }

    public PhetGraphic getBackground() {
        return this._background;
    }

    public void setElectronAnimationEnabled(boolean bl) {
        if (bl != this._electronAnimationEnabled) {
            this._electronAnimationEnabled = bl;
            this.updateElectrons();
        }
    }

    public boolean isElectronAnimationEnabled() {
        return this._electronAnimationEnabled;
    }

    public boolean isVisible() {
        return this._foreground.isVisible() || this._background.isVisible();
    }

    public void repaint() {
        this._foreground.repaint();
        this._background.repaint();
    }

    public Rectangle getBounds() {
        return this._foreground.getBounds().union(this._background.getBounds());
    }

    public void setElectronSpeedScale(double d) {
        assert (d > 0.0);
        if (d != this._electronSpeedScale) {
            this._electronSpeedScale = d;
            int n = this._electrons.size();
            for (int i = 0; i < n; ++i) {
                Electron electron = this._electrons.get(i);
                electron.setSpeedScale(this._electronSpeedScale);
            }
        }
    }

    public double getElectronSpeedScale() {
        return this._electronSpeedScale;
    }

    public void setEndsConnected(boolean bl) {
        if (bl != this._endsConnected) {
            this._endsConnected = bl;
            this.updateCoil();
            this.repaint();
        }
    }

    public void update() {
        if (this.isVisible()) {
            boolean bl = false;
            if (this.coilChanged()) {
                bl = true;
                this.updateCoil();
            }
            if (this._electronAnimationEnabled && this.electronsChanged()) {
                bl = true;
                this.updateElectrons();
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    private boolean coilChanged() {
        boolean bl = false;
        if (this._numberOfLoops != this._coilModel.getNumberOfLoops() || this._loopRadius != this._coilModel.getRadius() || this._wireWidth != this._coilModel.getWireWidth() || this._loopSpacing != this._coilModel.getLoopSpacing()) {
            bl = true;
            this._numberOfLoops = this._coilModel.getNumberOfLoops();
            this._loopRadius = this._coilModel.getRadius();
            this._wireWidth = this._coilModel.getWireWidth();
            this._loopSpacing = this._coilModel.getLoopSpacing();
        }
        return bl;
    }

    private boolean electronsChanged() {
        boolean bl = this._current != 0.0 || this._coilModel.getCurrentAmplitude() != 0.0;
        this._current = this._coilModel.getCurrentAmplitude();
        return bl;
    }

    private void updateCoil() {
        Object object;
        Object object2;
        Serializable serializable;
        this._foreground.clear();
        this._background.clear();
        this._electronPath.clear();
        for (int i = 0; i < this._electrons.size(); ++i) {
            Electron electron = this._electrons.get(i);
            electron.removeAllObservers();
            this._baseModel.removeModelElement(electron);
        }
        this._electrons.clear();
        BasicStroke basicStroke = new BasicStroke((float)this._coilModel.getWireWidth(), 1, 2);
        double d = this._coilModel.getRadius();
        int n = this._coilModel.getNumberOfLoops();
        int n2 = (int)this._coilModel.getLoopSpacing();
        int n3 = -(n2 * (n - 1) / 2);
        Point point = null;
        Point point2 = null;
        for (int i = 0; i < n; ++i) {
            Paint paint;
            ElectronPathDescriptor electronPathDescriptor;
            Object object3;
            QuadBezierSpline quadBezierSpline;
            Point point3;
            Point point4;
            int n4 = n3 + i * n2;
            if (i == 0) {
                serializable = new Point(-n2 / 2 + n4, (int)(-d));
                point4 = new Point(serializable.x - 15, serializable.y - 40);
                point3 = new Point(serializable.x - 20, serializable.y - 20);
                quadBezierSpline = new QuadBezierSpline(point4, point3, (Point)serializable);
                double d2 = d / 25.0 / 2.0;
                object3 = new ElectronPathDescriptor(quadBezierSpline, this._background, 1, d2);
                this._electronPath.add((ElectronPathDescriptor)object3);
                object2 = new GradientPaint(point4.x, 0.0f, this._middlegroundColor, serializable.x, 0.0f, this._backgroundColor);
                object = new PhetShapeGraphic(this._component);
                ((PhetShapeGraphic)object).setShape(quadBezierSpline);
                ((PhetShapeGraphic)object).setStroke(basicStroke);
                ((PhetShapeGraphic)object).setBorderPaint((Paint)object2);
                this._background.addGraphic((PhetGraphic)object);
                point = point4;
                serializable = new Point(-n2 / 2 + n4, (int)(-d));
                point4 = new Point((int)(d * 0.25) + n4, 0);
                point3 = new Point((int)(d * 0.15) + n4, (int)(-d * 0.7));
                quadBezierSpline = new QuadBezierSpline((Point)serializable, point3, point4);
                electronPathDescriptor = new ElectronPathDescriptor(quadBezierSpline, this._background, 1);
                this._electronPath.add(electronPathDescriptor);
                paint = this._backgroundColor;
                object3 = new PhetShapeGraphic(this._component);
                ((PhetShapeGraphic)object3).setShape(quadBezierSpline);
                ((PhetShapeGraphic)object3).setStroke(basicStroke);
                ((PhetShapeGraphic)object3).setBorderPaint(paint);
                this._background.addGraphic((PhetGraphic)object3);
            } else {
                serializable = new Point(-n2 + n4, (int)(-d));
                point4 = new Point((int)(d * 0.25) + n4, 0);
                point3 = new Point((int)(d * 0.15) + n4, (int)(-d * 1.2));
                quadBezierSpline = new QuadBezierSpline((Point)serializable, point3, point4);
                electronPathDescriptor = new ElectronPathDescriptor(quadBezierSpline, this._background, 1);
                this._electronPath.add(electronPathDescriptor);
                paint = new GradientPaint((int)((double)serializable.x + d * 0.1), (int)(-d), this._middlegroundColor, n4, (int)(-(d * 0.92)), this._backgroundColor);
                object3 = new PhetShapeGraphic(this._component);
                ((PhetShapeGraphic)object3).setShape(quadBezierSpline);
                ((PhetShapeGraphic)object3).setStroke(basicStroke);
                ((PhetShapeGraphic)object3).setBorderPaint(paint);
                this._background.addGraphic((PhetGraphic)object3);
            }
            serializable = new Point((int)(d * 0.25) + n4, 0);
            point4 = new Point(n4, (int)d);
            point3 = new Point((int)(d * 0.35) + n4, (int)(d * 1.2));
            quadBezierSpline = new QuadBezierSpline((Point)serializable, point3, point4);
            electronPathDescriptor = new ElectronPathDescriptor(quadBezierSpline, this._background, 1);
            this._electronPath.add(electronPathDescriptor);
            paint = new GradientPaint(0.0f, (int)(d * 0.92), this._backgroundColor, 0.0f, (int)d, this._middlegroundColor);
            object3 = new PhetShapeGraphic(this._component);
            ((PhetShapeGraphic)object3).setShape(quadBezierSpline);
            ((PhetShapeGraphic)object3).setStroke(basicStroke);
            ((PhetShapeGraphic)object3).setBorderPaint(paint);
            this._background.addGraphic((PhetGraphic)object3);
            serializable = new Point(n4, (int)d);
            point4 = new Point((int)(-d * 0.25) + n4, 0);
            point3 = new Point((int)(-d * 0.25) + n4, (int)(d * 0.8));
            quadBezierSpline = new QuadBezierSpline((Point)serializable, point3, point4);
            electronPathDescriptor = new ElectronPathDescriptor(quadBezierSpline, this._foreground, 0);
            this._electronPath.add(electronPathDescriptor);
            paint = new GradientPaint((int)(-d * 0.25) + n4, 0.0f, this._foregroundColor, (int)(-d * 0.15) + n4, 0.0f, this._middlegroundColor);
            object3 = new PhetShapeGraphic(this._component);
            ((PhetShapeGraphic)object3).setShape(quadBezierSpline);
            ((PhetShapeGraphic)object3).setStroke(basicStroke);
            ((PhetShapeGraphic)object3).setBorderPaint(paint);
            this._foreground.addGraphic((PhetGraphic)object3);
            serializable = new Point((int)(-d * 0.25) + n4, 0);
            point4 = new Point(n4, (int)(-d));
            point3 = new Point((int)(-d * 0.25) + n4, (int)(-d * 0.8));
            quadBezierSpline = new QuadBezierSpline((Point)serializable, point3, point4);
            electronPathDescriptor = new ElectronPathDescriptor(quadBezierSpline, this._foreground, 0);
            this._electronPath.add(electronPathDescriptor);
            paint = new GradientPaint((int)(-d * 0.25) + n4, 0.0f, this._foregroundColor, (int)(-d * 0.15) + n4, 0.0f, this._middlegroundColor);
            object3 = new PhetShapeGraphic(this._component);
            ((PhetShapeGraphic)object3).setShape(quadBezierSpline);
            ((PhetShapeGraphic)object3).setStroke(basicStroke);
            ((PhetShapeGraphic)object3).setBorderPaint(paint);
            this._foreground.addGraphic((PhetGraphic)object3);
            if (i != n - 1) continue;
            serializable = new Point(n4, (int)(-d));
            point4 = new Point(serializable.x + 15, serializable.y - 40);
            point3 = new Point(serializable.x + 20, serializable.y - 20);
            quadBezierSpline = new QuadBezierSpline((Point)serializable, point3, point4);
            double d3 = d / 25.0 / 2.0;
            object3 = new ElectronPathDescriptor(quadBezierSpline, this._foreground, 0, d3);
            this._electronPath.add((ElectronPathDescriptor)object3);
            object2 = this._middlegroundColor;
            object = new PhetShapeGraphic(this._component);
            ((PhetShapeGraphic)object).setShape(quadBezierSpline);
            ((PhetShapeGraphic)object).setStroke(basicStroke);
            ((PhetShapeGraphic)object).setBorderPaint((Paint)object2);
            this._foreground.addGraphic((PhetGraphic)object);
            point2 = point4;
        }
        if (this._endsConnected) {
            Line2D.Double double_ = new Line2D.Double(point.getX(), point.getY(), point2.getX(), point2.getY());
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this._component);
            serializable = this._middlegroundColor;
            phetShapeGraphic.setShape(double_);
            phetShapeGraphic.setStroke(basicStroke);
            phetShapeGraphic.setBorderPaint((Paint)((Object)serializable));
            this._foreground.addGraphic(phetShapeGraphic);
        }
        double d4 = this.calculateElectronSpeed();
        int n5 = this._electronPath.size() - 1;
        for (int i = 0; i < this._electronPath.size(); ++i) {
            int n6 = i == 0 ? 2 : (i == n5 ? 2 : (int)(d / 25.0));
            for (int j = 0; j < n6; ++j) {
                double d5 = (double)j / (double)n6;
                object2 = new Electron();
                ((Electron)object2).setPath(this._electronPath);
                ((Electron)object2).setPositionAlongPath(i, d5);
                ((Electron)object2).setSpeed(d4);
                ((FaradayObservable)object2).setEnabled(this._electronAnimationEnabled);
                ((Electron)object2).setSpeedScale(this._electronSpeedScale);
                this._electrons.add((Electron)object2);
                this._baseModel.addModelElement((ModelElement)object2);
                object = ((Electron)object2).getPathDescriptor();
                CompositePhetGraphic compositePhetGraphic = ((ElectronPathDescriptor)object).getParent();
                ElectronGraphic electronGraphic = new ElectronGraphic(this._component, compositePhetGraphic, (Electron)object2);
                ((ElectronPathDescriptor)object).getParent().addGraphic(electronGraphic);
            }
        }
    }

    private void updateElectrons() {
        double d = this.calculateElectronSpeed();
        int n = this._electrons.size();
        for (int i = 0; i < n; ++i) {
            Electron electron = this._electrons.get(i);
            electron.setEnabled(this._electronAnimationEnabled);
            electron.setSpeed(d);
        }
    }

    private double calculateElectronSpeed() {
        double d = this._coilModel.getCurrentAmplitude();
        if (Math.abs(d) < 0.001) {
            d = 0.0;
        }
        return d;
    }

    public Rectangle[] getCollisionBounds() {
        if (this.isVisible()) {
            if (this._collisionBounds == null) {
                this._collisionBounds = new Rectangle[2];
                this._collisionBounds[0] = new Rectangle();
                this._collisionBounds[1] = new Rectangle();
            }
            Rectangle rectangle = this.getBounds();
            this._collisionBounds[0].setBounds(rectangle.x + 5, rectangle.y, rectangle.width - 25, 56);
            this._collisionBounds[1].setBounds(rectangle.x + 35, rectangle.y + rectangle.height - 19, rectangle.width - 58, 18);
            return this._collisionBounds;
        }
        return null;
    }
}

