/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.faraday.model.AbstractMagnet;
import edu.colorado.phet.faraday.view.CompassNeedleCache;
import edu.colorado.phet.faraday.view.NeedleColorStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;

public abstract class AbstractBFieldGraphic
extends PhetGraphic {
    private static final Dimension DEFAULT_NEEDLE_SIZE = new Dimension(20, 40);
    private static final RenderingHints RENDERING_HINTS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private final AbstractMagnet _magnetModel;
    private int _xSpacing;
    private int _ySpacing;
    private GridPoint[] _gridPoints;
    private CompassNeedleCache _needleCache;
    private final double _strengthThreshold;
    private final Rectangle _gridBounds;
    private final Point _point;
    private final Vector2D _fieldVector;
    private double _intensityScale;

    public AbstractBFieldGraphic(Component component, AbstractMagnet abstractMagnet, int n, int n2) {
        super(component);
        assert (component != null);
        this.setIgnoreMouse(true);
        this._magnetModel = abstractMagnet;
        this._xSpacing = n;
        this._ySpacing = n2;
        this._strengthThreshold = 0.02;
        this._needleCache = new CompassNeedleCache();
        this._needleCache.setNeedleSize(DEFAULT_NEEDLE_SIZE);
        this._needleCache.populate();
        this._gridBounds = new Rectangle(0, 0, component.getWidth(), component.getHeight());
        this._point = new Point();
        this._fieldVector = new Vector2D();
        this._intensityScale = 2.7;
    }

    protected abstract GridPoint[] createGridPoints();

    public void setSpacing(int n, int n2) {
        this._xSpacing = n;
        this._ySpacing = n2;
        this.updateGridPoints();
    }

    public int getXSpacing() {
        return this._xSpacing;
    }

    public int getYSpacing() {
        return this._ySpacing;
    }

    public void setNeedleSize(Dimension dimension) {
        assert (dimension != null);
        this._needleCache.setNeedleSize(dimension);
        this._needleCache.populate();
        this.updateGridPoints();
    }

    public Dimension getNeedleSize() {
        return new Dimension(this._needleCache.getNeedleSize());
    }

    public void setGridBackground(Color color) {
        NeedleColorStrategy needleColorStrategy = NeedleColorStrategy.createStrategy(color);
        this.setNeedleColorStrategy(needleColorStrategy);
    }

    protected void setNeedleColorStrategy(NeedleColorStrategy needleColorStrategy) {
        this._needleCache.setNeedleColorStrategy(needleColorStrategy);
    }

    protected void setGridBounds(int n, int n2, int n3, int n4) {
        this._gridBounds.setBounds(n, n2, n3, n4);
        this.setBoundsDirty();
        this.updateGridPoints();
    }

    protected Rectangle getGridBoundsReference() {
        return this._gridBounds;
    }

    public void setIntensityScale(double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException("intensityScale must be >= 1: " + d);
        }
        if (d != this._intensityScale) {
            this._intensityScale = d;
            this.updateGridPoints();
        }
    }

    public double getIntensityScale() {
        return this._intensityScale;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateGridPoints();
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            graphics2D.setRenderingHints(RENDERING_HINTS);
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this._gridPoints.length; ++i) {
                GridPoint gridPoint = this._gridPoints[i];
                Color color = this._needleCache.getNorthColor(gridPoint.getIntensity());
                Color color2 = this._needleCache.getSouthColor(gridPoint.getIntensity());
                Shape shape = this._needleCache.getNorthShape(gridPoint.getDirection());
                Shape shape2 = this._needleCache.getSouthShape(gridPoint.getDirection());
                if (!(gridPoint.getIntensity() >= this._strengthThreshold)) continue;
                graphics2D.translate(gridPoint.getX() - d2, gridPoint.getY() - d);
                graphics2D.setPaint(color);
                graphics2D.fill(shape);
                graphics2D.setPaint(color2);
                graphics2D.fill(shape2);
                d2 = gridPoint.getX();
                d = gridPoint.getY();
            }
            super.restoreGraphicsState();
        }
    }

    protected Rectangle determineBounds() {
        return this._gridBounds;
    }

    protected void updateGridPoints() {
        this.updatePositions();
        this.updateStrengthAndOrientation();
        this.repaint();
    }

    protected void updatePositions() {
        this._gridPoints = this.createGridPoints();
    }

    protected void updateStrengthAndOrientation() {
        if (this.isVisible()) {
            for (int i = 0; i < this._gridPoints.length; ++i) {
                GridPoint gridPoint = this._gridPoints[i];
                if (this._magnetModel.getStrength() == 0.0) {
                    gridPoint.setIntensity(0.0);
                    continue;
                }
                this._point.setLocation(gridPoint.getX(), gridPoint.getY());
                this._magnetModel.getBField(this._point, this._fieldVector);
                double d = this._fieldVector.getAngle();
                double d2 = this._fieldVector.getMagnitude();
                double d3 = d2 / this._magnetModel.getMaxStrength();
                double d4 = Math.pow(d3, 1.0 / this._intensityScale);
                d4 *= 2.0;
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                gridPoint.setIntensity(d4);
                gridPoint.setDirection(d);
            }
        }
    }

    protected static class GridPoint {
        public double _x;
        public double _y;
        public double _direction;
        public double _intensity;

        public GridPoint(double d, double d2) {
            this(d, d2, 0.0, 0.0);
        }

        public GridPoint(double d, double d2, double d3, double d4) {
            this._x = d;
            this._y = d2;
            this._direction = d3;
            this._intensity = d4;
        }

        public double getX() {
            return this._x;
        }

        public double getY() {
            return this._y;
        }

        public void setLocation(double d, double d2) {
            this._x = d;
            this._y = d2;
        }

        public void setDirection(double d) {
            this._direction = d;
        }

        public double getDirection() {
            return this._direction;
        }

        public void setIntensity(double d) {
            if (!(d >= 0.0) || !(d <= 1.0)) {
                throw new IllegalArgumentException("intensity out of bounds: " + d);
            }
            this._intensity = d;
        }

        public double getIntensity() {
            return this._intensity;
        }

        public String toString() {
            return "GridPoint x=" + this._x + " y=" + this._y + " direction=" + this._direction + " intensity=" + this._intensity;
        }
    }
}

