/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.faraday.FaradayConstants;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.FaradayControlPanel;
import edu.colorado.phet.faraday.control.panel.DeveloperControlsPanel;
import edu.colorado.phet.faraday.control.panel.ElectromagnetPanel;
import edu.colorado.phet.faraday.control.panel.PickupCoilPanel;
import edu.colorado.phet.faraday.model.ACPowerSupply;
import edu.colorado.phet.faraday.model.AbstractCurrentSource;
import edu.colorado.phet.faraday.model.Battery;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.model.Electromagnet;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.model.Lightbulb;
import edu.colorado.phet.faraday.model.PickupCoil;
import edu.colorado.phet.faraday.model.SourceCoil;
import edu.colorado.phet.faraday.model.Voltmeter;
import edu.colorado.phet.faraday.module.FaradayModule;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import edu.colorado.phet.faraday.view.CompassGraphic;
import edu.colorado.phet.faraday.view.ElectromagnetGraphic;
import edu.colorado.phet.faraday.view.FieldMeterGraphic;
import edu.colorado.phet.faraday.view.PickupCoilGraphic;
import java.awt.Color;
import java.awt.Point;

public class TransformerModule
extends FaradayModule {
    private static final Point ELECTROMAGNET_LOCATION = new Point(200, 400);
    private static final Point COMPASS_LOCATION = new Point(100, 525);
    private static final Point FIELD_METER_LOCATION = new Point(150, 400);
    private static final Point PICKUP_COIL_LOCATION = new Point(500, 400);
    private static final Color APPARATUS_BACKGROUND = Color.BLACK;
    private Battery _batteryModel;
    private ACPowerSupply _acPowerSupplyModel;
    private SourceCoil _sourceCoilModel;
    private Electromagnet _electromagnetModel;
    private Compass _compassModel;
    private FieldMeter _fieldMeterModel;
    private PickupCoil _pickupCoilModel;
    private Lightbulb _lightbulbModel;
    private Voltmeter _voltmeterModel;
    private ElectromagnetGraphic _electromagnetGraphic;
    private PickupCoilGraphic _pickupCoilGraphic;
    private BFieldOutsideGraphic _bFieldOutsideGraphic;
    private ElectromagnetPanel _electromagnetPanel;
    private PickupCoilPanel _pickupCoilPanel;

    public TransformerModule() {
        super(FaradayStrings.TITLE_TRANSFORMER_MODULE);
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._batteryModel = new Battery();
        this._batteryModel.setMaxVoltage(10.0);
        this._batteryModel.setAmplitude(1.0);
        this._acPowerSupplyModel = new ACPowerSupply();
        this._acPowerSupplyModel.setMaxVoltage(110.0);
        this._acPowerSupplyModel.setMaxAmplitude(0.5);
        this._acPowerSupplyModel.setFrequency(0.5);
        this._acPowerSupplyModel.setEnabled(false);
        baseModel.addModelElement(this._acPowerSupplyModel);
        this._sourceCoilModel = new SourceCoil();
        this._sourceCoilModel.setNumberOfLoops(4);
        this._sourceCoilModel.setRadius(50.0);
        this._sourceCoilModel.setDirection(0.0);
        AbstractCurrentSource abstractCurrentSource = null;
        if (this._batteryModel.isEnabled()) {
            abstractCurrentSource = this._batteryModel;
        } else if (this._acPowerSupplyModel.isEnabled()) {
            abstractCurrentSource = this._acPowerSupplyModel;
        }
        this._electromagnetModel = new Electromagnet(this._sourceCoilModel, abstractCurrentSource);
        this._electromagnetModel.setMaxStrength(300.0);
        this._electromagnetModel.setLocation(ELECTROMAGNET_LOCATION);
        this._electromagnetModel.setDirection(0.0);
        this._electromagnetModel.update();
        this._compassModel = new Compass(this._electromagnetModel, this.getClock());
        this._compassModel.setBehavior(1);
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setEnabled(false);
        baseModel.addModelElement(this._compassModel);
        this._fieldMeterModel = new FieldMeter(this._electromagnetModel);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        this._pickupCoilModel = new PickupCoil(this._electromagnetModel, 3500000.0, this.getName());
        this._pickupCoilModel.setNumberOfLoops(2);
        this._pickupCoilModel.setLoopArea(53014.37602932776);
        this._pickupCoilModel.setDirection(0.0);
        this._pickupCoilModel.setLocation(PICKUP_COIL_LOCATION);
        this._pickupCoilModel.setTransitionSmoothingScale(0.56);
        double d = this._electromagnetModel.getHeight() / 20.0;
        this._pickupCoilModel.setSamplePointsStrategy(new PickupCoil.VariableNumberOfSamplePointsStrategy(d));
        baseModel.addModelElement(this._pickupCoilModel);
        this._lightbulbModel = new Lightbulb(this._pickupCoilModel);
        this._lightbulbModel.setEnabled(true);
        this._lightbulbModel.setOffWhenCurrentChangesDirection(true);
        this._voltmeterModel = new Voltmeter(this._pickupCoilModel);
        this._voltmeterModel.setJiggleEnabled(true);
        this._voltmeterModel.setEnabled(false);
        baseModel.addModelElement(this._voltmeterModel);
        ApparatusPanel2 apparatusPanel2 = new ApparatusPanel2(this.getClock());
        apparatusPanel2.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel2);
        this._electromagnetGraphic = new ElectromagnetGraphic(apparatusPanel2, baseModel, this._electromagnetModel, this._sourceCoilModel, this._batteryModel, this._acPowerSupplyModel);
        apparatusPanel2.addChangeListener(this._electromagnetGraphic);
        apparatusPanel2.addGraphic(this._electromagnetGraphic.getForeground(), 5.0);
        apparatusPanel2.addGraphic(this._electromagnetGraphic.getBackground(), 1.0);
        this._pickupCoilGraphic = new PickupCoilGraphic(apparatusPanel2, baseModel, this._pickupCoilModel, this._lightbulbModel, this._voltmeterModel);
        this._pickupCoilGraphic.getCoilGraphic().setElectronSpeedScale(2.0);
        apparatusPanel2.addChangeListener(this._pickupCoilGraphic);
        apparatusPanel2.addGraphic(this._pickupCoilGraphic.getForeground(), 6.0);
        apparatusPanel2.addGraphic(this._pickupCoilGraphic.getBackground(), 2.0);
        this._bFieldOutsideGraphic = new BFieldOutsideGraphic(apparatusPanel2, this._electromagnetModel, 40, 40);
        this._bFieldOutsideGraphic.setNeedleSize(FaradayConstants.GRID_NEEDLE_SIZE);
        this._bFieldOutsideGraphic.setGridBackground(APPARATUS_BACKGROUND);
        this._bFieldOutsideGraphic.setVisible(false);
        apparatusPanel2.addChangeListener(this._bFieldOutsideGraphic);
        apparatusPanel2.addGraphic(this._bFieldOutsideGraphic, 3.0);
        super.setBFieldOutsideGraphic(this._bFieldOutsideGraphic);
        CompassGraphic compassGraphic = new CompassGraphic(apparatusPanel2, this._compassModel);
        compassGraphic.setLocation(COMPASS_LOCATION);
        apparatusPanel2.addChangeListener(compassGraphic);
        apparatusPanel2.addGraphic(compassGraphic, 4.0);
        FieldMeterGraphic fieldMeterGraphic = new FieldMeterGraphic(apparatusPanel2, this._fieldMeterModel);
        fieldMeterGraphic.setLocation(FIELD_METER_LOCATION);
        apparatusPanel2.addChangeListener(fieldMeterGraphic);
        apparatusPanel2.addGraphic(fieldMeterGraphic, 7.0);
        this._electromagnetGraphic.getCollisionDetector().add(compassGraphic);
        this._pickupCoilGraphic.getCollisionDetector().add(compassGraphic);
        compassGraphic.getCollisionDetector().add(this._electromagnetGraphic);
        compassGraphic.getCollisionDetector().add(this._pickupCoilGraphic);
        FaradayControlPanel faradayControlPanel = new FaradayControlPanel();
        this.setControlPanel(faradayControlPanel);
        this._electromagnetPanel = new ElectromagnetPanel(this._electromagnetModel, this._sourceCoilModel, this._batteryModel, this._acPowerSupplyModel, this._compassModel, this._fieldMeterModel, this._electromagnetGraphic, this._bFieldOutsideGraphic);
        faradayControlPanel.addControlFullWidth(this._electromagnetPanel);
        faradayControlPanel.addDefaultVerticalSpace();
        this._pickupCoilPanel = new PickupCoilPanel(this._pickupCoilModel, this._pickupCoilGraphic, this._lightbulbModel, this._voltmeterModel);
        faradayControlPanel.addControlFullWidth(this._pickupCoilPanel);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            faradayControlPanel.addDefaultVerticalSpace();
            DeveloperControlsPanel developerControlsPanel = new DeveloperControlsPanel(this._pickupCoilModel, this._pickupCoilGraphic, this._electromagnetGraphic, this._pickupCoilGraphic.getLightbulbGraphic(), null, this._bFieldOutsideGraphic);
            faradayControlPanel.addControlFullWidth(developerControlsPanel);
        }
        faradayControlPanel.addResetAllButton(this);
        this.reset();
    }

    public void reset() {
        this._batteryModel.setAmplitude(1.0);
        this._batteryModel.setEnabled(true);
        this._acPowerSupplyModel.setMaxAmplitude(0.5);
        this._acPowerSupplyModel.setFrequency(0.5);
        this._acPowerSupplyModel.setEnabled(false);
        this._sourceCoilModel.setNumberOfLoops(4);
        this._sourceCoilModel.setRadius(50.0);
        this._sourceCoilModel.setDirection(0.0);
        this._electromagnetModel.setLocation(ELECTROMAGNET_LOCATION);
        this._electromagnetModel.setDirection(0.0);
        if (this._batteryModel.isEnabled()) {
            this._electromagnetModel.setCurrentSource(this._batteryModel);
        } else {
            this._electromagnetModel.setCurrentSource(this._acPowerSupplyModel);
        }
        this._electromagnetModel.update();
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setEnabled(false);
        this._pickupCoilModel.setNumberOfLoops(2);
        this._pickupCoilModel.setLoopArea(53014.37602932776);
        this._pickupCoilModel.setDirection(0.0);
        this._pickupCoilModel.setLocation(PICKUP_COIL_LOCATION);
        this._lightbulbModel.setEnabled(true);
        this._voltmeterModel.setEnabled(false);
        this._electromagnetGraphic.getCoilGraphic().setElectronAnimationEnabled(true);
        this._pickupCoilGraphic.getCoilGraphic().setElectronAnimationEnabled(true);
        this._bFieldOutsideGraphic.setVisible(true);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        this._electromagnetPanel.update();
        this._pickupCoilPanel.update();
    }
}

