/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.faraday.FaradayConstants;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.FaradayControlPanel;
import edu.colorado.phet.faraday.control.panel.BarMagnetPanel;
import edu.colorado.phet.faraday.control.panel.DeveloperControlsPanel;
import edu.colorado.phet.faraday.control.panel.PickupCoilPanel;
import edu.colorado.phet.faraday.model.BarMagnet;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.model.Lightbulb;
import edu.colorado.phet.faraday.model.PickupCoil;
import edu.colorado.phet.faraday.model.Voltmeter;
import edu.colorado.phet.faraday.module.FaradayModule;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import edu.colorado.phet.faraday.view.BarMagnetGraphic;
import edu.colorado.phet.faraday.view.CompassGraphic;
import edu.colorado.phet.faraday.view.FieldMeterGraphic;
import edu.colorado.phet.faraday.view.PickupCoilGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;

public class PickupCoilModule
extends FaradayModule {
    private static final Point BAR_MAGNET_LOCATION = new Point(200, 400);
    private static final Point PICKUP_COIL_LOCATION = new Point(500, 400);
    private static final Point COMPASS_LOCATION = new Point(100, 525);
    private static final Point FIELD_METER_LOCATION = new Point(150, 400);
    private static final Color APPARATUS_BACKGROUND = Color.BLACK;
    private static final Dimension BAR_MAGNET_SIZE = FaradayConstants.BAR_MAGNET_SIZE;
    private BarMagnet _barMagnetModel;
    private Compass _compassModel;
    private FieldMeter _fieldMeterModel;
    private PickupCoil _pickupCoilModel;
    private Lightbulb _lightbulbModel;
    private Voltmeter _voltmeterModel;
    private BarMagnetGraphic _barMagnetGraphic;
    private PickupCoilGraphic _pickupCoilGraphic;
    private BFieldOutsideGraphic _bFieldOutsideGraphic;
    private BarMagnetPanel _barMagnetPanel;
    private PickupCoilPanel _pickupCoilPanel;

    public PickupCoilModule() {
        super(FaradayStrings.TITLE_PICKUP_COIL_MODULE);
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._barMagnetModel = new BarMagnet();
        this._barMagnetModel.setSize(BAR_MAGNET_SIZE.getWidth(), BAR_MAGNET_SIZE.getHeight());
        this._barMagnetModel.setMaxStrength(300.0);
        this._barMagnetModel.setMinStrength(0.0);
        this._barMagnetModel.setStrength(225.0);
        this._barMagnetModel.setLocation(BAR_MAGNET_LOCATION);
        this._barMagnetModel.setDirection(0.0);
        this._compassModel = new Compass(this._barMagnetModel, this.getClock());
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setBehavior(2);
        this._compassModel.setEnabled(false);
        baseModel.addModelElement(this._compassModel);
        this._fieldMeterModel = new FieldMeter(this._barMagnetModel);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        this._pickupCoilModel = new PickupCoil(this._barMagnetModel, 2700000.0, this.getName());
        this._pickupCoilModel.setNumberOfLoops(2);
        this._pickupCoilModel.setLoopArea(35342.917352885175);
        this._pickupCoilModel.setDirection(0.0);
        this._pickupCoilModel.setLocation(PICKUP_COIL_LOCATION);
        this._pickupCoilModel.setTransitionSmoothingScale(0.77);
        double d = this._barMagnetModel.getHeight() / 10.0;
        this._pickupCoilModel.setSamplePointsStrategy(new PickupCoil.VariableNumberOfSamplePointsStrategy(d));
        baseModel.addModelElement(this._pickupCoilModel);
        this._lightbulbModel = new Lightbulb(this._pickupCoilModel);
        this._lightbulbModel.setEnabled(true);
        this._voltmeterModel = new Voltmeter(this._pickupCoilModel);
        this._voltmeterModel.setJiggleEnabled(true);
        this._voltmeterModel.setEnabled(false);
        baseModel.addModelElement(this._voltmeterModel);
        ApparatusPanel2 apparatusPanel2 = new ApparatusPanel2(this.getClock());
        apparatusPanel2.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel2);
        this._barMagnetGraphic = new BarMagnetGraphic((Component)apparatusPanel2, this._barMagnetModel);
        apparatusPanel2.addChangeListener(this._barMagnetGraphic);
        apparatusPanel2.addGraphic(this._barMagnetGraphic, 3.0);
        this._pickupCoilGraphic = new PickupCoilGraphic(apparatusPanel2, baseModel, this._pickupCoilModel, this._lightbulbModel, this._voltmeterModel);
        this._pickupCoilGraphic.getCoilGraphic().setElectronSpeedScale(3.0);
        apparatusPanel2.addChangeListener(this._pickupCoilGraphic);
        apparatusPanel2.addGraphic(this._pickupCoilGraphic.getForeground(), 5.0);
        apparatusPanel2.addGraphic(this._pickupCoilGraphic.getBackground(), 1.0);
        this._bFieldOutsideGraphic = new BFieldOutsideGraphic(apparatusPanel2, this._barMagnetModel, 40, 40);
        this._bFieldOutsideGraphic.setNeedleSize(FaradayConstants.GRID_NEEDLE_SIZE);
        this._bFieldOutsideGraphic.setGridBackground(APPARATUS_BACKGROUND);
        this._bFieldOutsideGraphic.setVisible(false);
        apparatusPanel2.addChangeListener(this._bFieldOutsideGraphic);
        apparatusPanel2.addGraphic(this._bFieldOutsideGraphic, 2.0);
        super.setBFieldOutsideGraphic(this._bFieldOutsideGraphic);
        CompassGraphic compassGraphic = new CompassGraphic(apparatusPanel2, this._compassModel);
        compassGraphic.setLocation(COMPASS_LOCATION);
        apparatusPanel2.addChangeListener(compassGraphic);
        apparatusPanel2.addGraphic(compassGraphic, 4.0);
        FieldMeterGraphic fieldMeterGraphic = new FieldMeterGraphic(apparatusPanel2, this._fieldMeterModel);
        fieldMeterGraphic.setLocation(FIELD_METER_LOCATION);
        apparatusPanel2.addChangeListener(fieldMeterGraphic);
        apparatusPanel2.addGraphic(fieldMeterGraphic, 6.0);
        this._barMagnetGraphic.getCollisionDetector().add(compassGraphic);
        this._barMagnetGraphic.getCollisionDetector().add(this._pickupCoilGraphic);
        compassGraphic.getCollisionDetector().add(this._barMagnetGraphic);
        compassGraphic.getCollisionDetector().add(this._pickupCoilGraphic);
        this._pickupCoilGraphic.getCollisionDetector().add(this._barMagnetGraphic);
        this._pickupCoilGraphic.getCollisionDetector().add(compassGraphic);
        this.getClockControlPanel().setEnabled(false);
        FaradayControlPanel faradayControlPanel = new FaradayControlPanel();
        this.setControlPanel(faradayControlPanel);
        this._barMagnetPanel = new BarMagnetPanel(this._barMagnetModel, this._compassModel, this._fieldMeterModel, null, this._bFieldOutsideGraphic, null);
        this._barMagnetPanel.setSeeInsideControlVisible(false);
        faradayControlPanel.addControlFullWidth(this._barMagnetPanel);
        faradayControlPanel.addDefaultVerticalSpace();
        this._pickupCoilPanel = new PickupCoilPanel(this._pickupCoilModel, this._pickupCoilGraphic, this._lightbulbModel, this._voltmeterModel);
        faradayControlPanel.addControlFullWidth(this._pickupCoilPanel);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            faradayControlPanel.addDefaultVerticalSpace();
            DeveloperControlsPanel developerControlsPanel = new DeveloperControlsPanel(this._pickupCoilModel, this._pickupCoilGraphic, null, this._pickupCoilGraphic.getLightbulbGraphic(), null, this._bFieldOutsideGraphic);
            faradayControlPanel.addControlFullWidth(developerControlsPanel);
        }
        faradayControlPanel.addResetAllButton(this);
        this.reset();
    }

    public void reset() {
        this._barMagnetModel.setStrength(225.0);
        this._barMagnetModel.setLocation(BAR_MAGNET_LOCATION);
        this._barMagnetModel.setDirection(0.0);
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setEnabled(false);
        this._pickupCoilModel.setNumberOfLoops(2);
        this._pickupCoilModel.setLoopArea(35342.917352885175);
        this._pickupCoilModel.setDirection(0.0);
        this._pickupCoilModel.setLocation(PICKUP_COIL_LOCATION);
        this._lightbulbModel.setEnabled(true);
        this._voltmeterModel.setEnabled(false);
        this._pickupCoilGraphic.getCoilGraphic().setElectronAnimationEnabled(true);
        this._bFieldOutsideGraphic.setVisible(true);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        this._barMagnetPanel.update();
        this._pickupCoilPanel.update();
    }
}

