/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.faraday.FaradayConstants;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.FaradayControlPanel;
import edu.colorado.phet.faraday.control.panel.DeveloperControlsPanel;
import edu.colorado.phet.faraday.control.panel.PickupCoilPanel;
import edu.colorado.phet.faraday.control.panel.TurbinePanel;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.model.Lightbulb;
import edu.colorado.phet.faraday.model.PickupCoil;
import edu.colorado.phet.faraday.model.Turbine;
import edu.colorado.phet.faraday.model.Voltmeter;
import edu.colorado.phet.faraday.module.FaradayModule;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import edu.colorado.phet.faraday.view.CompassGraphic;
import edu.colorado.phet.faraday.view.FieldMeterGraphic;
import edu.colorado.phet.faraday.view.PickupCoilGraphic;
import edu.colorado.phet.faraday.view.TurbineGraphic;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;

public class GeneratorModule
extends FaradayModule {
    private static final Point TURBINE_LOCATION = new Point(285, 400);
    private static final Point PICKUP_COIL_LOCATION = new Point(550, GeneratorModule.TURBINE_LOCATION.y);
    private static final Point COMPASS_LOCATION = new Point(350, 175);
    private static final Point FIELD_METER_LOCATION = new Point(450, 460);
    private static final Color APPARATUS_BACKGROUND = Color.BLACK;
    private static final Dimension TURBINE_SIZE = FaradayConstants.BAR_MAGNET_SIZE;
    private Turbine _turbineModel;
    private Compass _compassModel;
    private FieldMeter _fieldMeterModel;
    private PickupCoil _pickupCoilModel;
    private Lightbulb _lightbulbModel;
    private Voltmeter _voltmeterModel;
    private PickupCoilGraphic _pickupCoilGraphic;
    private BFieldOutsideGraphic _bFieldOutsideGraphic;
    private PickupCoilPanel _pickupCoilPanel;
    private TurbinePanel _turbinePanel;

    public GeneratorModule() {
        super(FaradayStrings.TITLE_GENERATOR_MODULE);
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._turbineModel = new Turbine();
        this._turbineModel.setSize(TURBINE_SIZE.getWidth(), TURBINE_SIZE.getHeight());
        this._turbineModel.setMaxStrength(300.0);
        this._turbineModel.setMinStrength(0.0);
        this._turbineModel.setStrength(225.0);
        this._turbineModel.setLocation(TURBINE_LOCATION);
        this._turbineModel.setDirection(0.0);
        this._turbineModel.setSpeed(0.0);
        baseModel.addModelElement(this._turbineModel);
        this._compassModel = new Compass(this._turbineModel, this.getClock());
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setBehavior(0);
        this._compassModel.setEnabled(false);
        baseModel.addModelElement(this._compassModel);
        this._fieldMeterModel = new FieldMeter(this._turbineModel);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        this._pickupCoilModel = new PickupCoil(this._turbineModel, 26000.0, this.getName());
        this._pickupCoilModel.setNumberOfLoops(2);
        this._pickupCoilModel.setLoopArea(35342.917352885175);
        this._pickupCoilModel.setDirection(0.0);
        this._pickupCoilModel.setLocation(PICKUP_COIL_LOCATION);
        this._pickupCoilModel.setTransitionSmoothingScale(1.0);
        baseModel.addModelElement(this._pickupCoilModel);
        this._lightbulbModel = new Lightbulb(this._pickupCoilModel);
        this._lightbulbModel.setEnabled(true);
        this._lightbulbModel.setOffWhenCurrentChangesDirection(true);
        this._voltmeterModel = new Voltmeter(this._pickupCoilModel);
        this._voltmeterModel.setJiggleEnabled(true);
        this._voltmeterModel.setEnabled(false);
        baseModel.addModelElement(this._voltmeterModel);
        ApparatusPanel2 apparatusPanel2 = new ApparatusPanel2(this.getClock());
        apparatusPanel2.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel2);
        TurbineGraphic turbineGraphic = new TurbineGraphic(apparatusPanel2, this._turbineModel);
        apparatusPanel2.addChangeListener(turbineGraphic);
        apparatusPanel2.addGraphic(turbineGraphic, 3.0);
        this._pickupCoilGraphic = new PickupCoilGraphic(apparatusPanel2, baseModel, this._pickupCoilModel, this._lightbulbModel, this._voltmeterModel);
        this._pickupCoilGraphic.setDraggingEnabled(false);
        this._pickupCoilGraphic.getCoilGraphic().setElectronSpeedScale(1.0);
        apparatusPanel2.addChangeListener(this._pickupCoilGraphic);
        apparatusPanel2.addGraphic(this._pickupCoilGraphic.getForeground(), 5.0);
        apparatusPanel2.addGraphic(this._pickupCoilGraphic.getBackground(), 1.0);
        this._bFieldOutsideGraphic = new BFieldOutsideGraphic(apparatusPanel2, this._turbineModel, 40, 40);
        this._bFieldOutsideGraphic.setNeedleSize(FaradayConstants.GRID_NEEDLE_SIZE);
        this._bFieldOutsideGraphic.setGridBackground(APPARATUS_BACKGROUND);
        this._bFieldOutsideGraphic.setVisible(false);
        apparatusPanel2.addChangeListener(this._bFieldOutsideGraphic);
        apparatusPanel2.addGraphic(this._bFieldOutsideGraphic, 2.0);
        super.setBFieldOutsideGraphic(this._bFieldOutsideGraphic);
        CompassGraphic compassGraphic = new CompassGraphic(apparatusPanel2, this._compassModel);
        compassGraphic.setLocation(COMPASS_LOCATION);
        apparatusPanel2.addChangeListener(compassGraphic);
        apparatusPanel2.addGraphic(compassGraphic, 4.0);
        FieldMeterGraphic fieldMeterGraphic = new FieldMeterGraphic(apparatusPanel2, this._fieldMeterModel);
        fieldMeterGraphic.setLocation(FIELD_METER_LOCATION);
        apparatusPanel2.addChangeListener(fieldMeterGraphic);
        apparatusPanel2.addGraphic(fieldMeterGraphic, 6.0);
        compassGraphic.getCollisionDetector().add(this._pickupCoilGraphic);
        FaradayControlPanel faradayControlPanel = new FaradayControlPanel();
        this.setControlPanel(faradayControlPanel);
        this._turbinePanel = new TurbinePanel(this._turbineModel, this._compassModel, this._fieldMeterModel, this._bFieldOutsideGraphic);
        faradayControlPanel.addControlFullWidth(this._turbinePanel);
        faradayControlPanel.addDefaultVerticalSpace();
        this._pickupCoilPanel = new PickupCoilPanel(this._pickupCoilModel, this._pickupCoilGraphic, this._lightbulbModel, this._voltmeterModel);
        faradayControlPanel.addControlFullWidth(this._pickupCoilPanel);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            faradayControlPanel.addDefaultVerticalSpace();
            DeveloperControlsPanel developerControlsPanel = new DeveloperControlsPanel(this._pickupCoilModel, this._pickupCoilGraphic, null, this._pickupCoilGraphic.getLightbulbGraphic(), null, this._bFieldOutsideGraphic);
            faradayControlPanel.addControlFullWidth(developerControlsPanel);
        }
        faradayControlPanel.addResetAllButton(this);
        this.reset();
    }

    public void reset() {
        this._turbineModel.setStrength(225.0);
        this._turbineModel.setLocation(TURBINE_LOCATION);
        this._turbineModel.setDirection(0.0);
        this._turbineModel.setSpeed(0.0);
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setEnabled(true);
        this._pickupCoilModel.setNumberOfLoops(2);
        this._pickupCoilModel.setLoopArea(35342.917352885175);
        this._pickupCoilModel.setDirection(0.0);
        this._pickupCoilModel.setLocation(PICKUP_COIL_LOCATION);
        this._lightbulbModel.setEnabled(true);
        this._voltmeterModel.setEnabled(false);
        this._pickupCoilGraphic.getCoilGraphic().setElectronAnimationEnabled(true);
        this._bFieldOutsideGraphic.setVisible(false);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        this._turbinePanel.update();
        this._pickupCoilPanel.update();
    }
}

