/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.faraday.model.AbstractCoil;
import edu.colorado.phet.faraday.model.AbstractMagnet;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class PickupCoil
extends AbstractCoil
implements ModelElement,
SimpleObserver {
    private AbstractMagnet _magnetModel;
    private double _averageBx;
    private double _flux;
    private double _deltaFlux;
    private double _emf;
    private double _biggestAbsEmf;
    private Point2D[] _samplePoints;
    private SamplePointsStrategy _samplePointsStrategy;
    private double _transitionSmoothingScale;
    private double _calibrationEmf;
    private String _moduleName;
    private AffineTransform _someTransform;
    private Point2D _samplePoint;
    private Vector2D _sampleVector;

    public PickupCoil(AbstractMagnet abstractMagnet, double d, String string) {
        this(abstractMagnet, d, string, new ConstantNumberOfSamplePointsStrategy(9));
    }

    private PickupCoil(AbstractMagnet abstractMagnet, double d, String string, SamplePointsStrategy samplePointsStrategy) {
        assert (abstractMagnet != null);
        this._magnetModel = abstractMagnet;
        this._magnetModel.addObserver(this);
        assert (d >= 1.0);
        this._calibrationEmf = d;
        this._moduleName = string;
        this._samplePointsStrategy = samplePointsStrategy;
        this._samplePoints = null;
        this._averageBx = 0.0;
        this._flux = 0.0;
        this._deltaFlux = 0.0;
        this._emf = 0.0;
        this._biggestAbsEmf = 0.0;
        this._transitionSmoothingScale = 1.0;
        this._someTransform = new AffineTransform();
        this._samplePoint = new Point2D.Double();
        this._sampleVector = new Vector2D();
        this.setLoopSpacing(1.5 * this.getWireWidth());
        this.updateSamplePoints();
    }

    public double getFlux() {
        return this._flux;
    }

    public double getDeltaFlux() {
        return this._deltaFlux;
    }

    public double getAverageBx() {
        return this._averageBx;
    }

    public double getEmf() {
        return this._emf;
    }

    public Point2D[] getSamplePoints() {
        return this._samplePoints;
    }

    public void setRadius(double d) {
        super.setRadius(d);
        this.updateSamplePoints();
    }

    public void setSamplePointsStrategy(SamplePointsStrategy samplePointsStrategy) {
        this._samplePointsStrategy = samplePointsStrategy;
        this.updateSamplePoints();
    }

    public void setTransitionSmoothingScale(double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new IllegalArgumentException("scale must be > 0 and <= 1: " + d);
        }
        this._transitionSmoothingScale = d;
    }

    public double getTransitionSmoothingScale() {
        return this._transitionSmoothingScale;
    }

    public void setCalibrationEmf(double d) {
        if (!(d >= 1.0)) {
            throw new IllegalArgumentException("calibrationEmf must be >= 1: " + d);
        }
        this._calibrationEmf = d;
    }

    public double getCalibrationEmf() {
        return this._calibrationEmf;
    }

    public void update() {
    }

    private void updateSamplePoints() {
        this._samplePoints = this._samplePointsStrategy.createSamplePoints(this);
    }

    public void stepInTime(double d) {
        if (this.isEnabled()) {
            this.updateEmf(d);
        }
    }

    private void updateEmf(double d) {
        double d2 = this.getSumBx();
        this._averageBx = d2 / (double)this._samplePoints.length;
        double d3 = this.getEffectiveLoopArea();
        double d4 = d3 * this._averageBx;
        double d5 = (double)this.getNumberOfLoops() * d4;
        this._deltaFlux = d5 - this._flux;
        this._flux = d5;
        double d6 = -(this._deltaFlux / d);
        if (d6 != this._emf) {
            this._emf = d6;
            double d7 = MathUtil.clamp(-1.0, d6 / this._calibrationEmf, 1.0);
            this.setCurrentAmplitude(d7);
        }
        this.calibrateEmf();
    }

    private void calibrateEmf() {
        double d = Math.abs(this._emf);
        if (d > this._biggestAbsEmf) {
            this._biggestAbsEmf = this._emf;
            if (this._biggestAbsEmf > this._calibrationEmf && PhetApplication.getInstance().isDeveloperControlsEnabled()) {
                System.out.println("PickupCoil.updateEmf: you should recalibrate module \"" + this._moduleName + "\" with CALIBRATION_EMF=" + this._biggestAbsEmf);
            }
        }
    }

    private double getSumBx() {
        double d = this._magnetModel.getStrength();
        double d2 = 0.0;
        for (int i = 0; i < this._samplePoints.length; ++i) {
            this._samplePoint.setLocation(this.getX() + this._samplePoints[i].getX(), this.getY() + this._samplePoints[i].getY());
            if (this.getDirection() != 0.0) {
                this._someTransform.setToIdentity();
                this._someTransform.rotate(this.getDirection(), this.getX(), this.getY());
                this._someTransform.transform(this._samplePoint, this._samplePoint);
            }
            this._magnetModel.getBField(this._samplePoint, this._sampleVector);
            double d3 = this._sampleVector.getX();
            if (Math.abs(d3) == d) {
                d3 *= this._transitionSmoothingScale;
            }
            d2 += d3;
        }
        return d2;
    }

    private double getEffectiveLoopArea() {
        double d = 68.0;
        double d2 = 2.0 * this.getRadius();
        return d * d2;
    }

    public static class VariableNumberOfSamplePointsStrategy
    implements SamplePointsStrategy {
        private final double _ySpacing;

        public VariableNumberOfSamplePointsStrategy(double d) {
            if (d <= 0.0) {
                throw new IllegalArgumentException("ySpacing must be >= 0");
            }
            this._ySpacing = d;
        }

        public Point2D[] createSamplePoints(PickupCoil pickupCoil) {
            int n = (int)(pickupCoil.getRadius() / this._ySpacing);
            Point2D[] point2DArray = new Point2D[1 + 2 * n];
            int n2 = 0;
            point2DArray[n2++] = new Point2D.Double(0.0, 0.0);
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                point2DArray[n2++] = new Point2D.Double(0.0, d += this._ySpacing);
                point2DArray[n2++] = new Point2D.Double(0.0, -d);
            }
            return point2DArray;
        }
    }

    public static class ConstantNumberOfSamplePointsStrategy
    implements SamplePointsStrategy {
        private final int _numberOfSamplePoints;

        public ConstantNumberOfSamplePointsStrategy(int n) {
            if (n < 1 || n % 2 != 1) {
                throw new IllegalArgumentException("numberOfSamplePoints must be > 0 and odd");
            }
            this._numberOfSamplePoints = n;
        }

        public Point2D[] createSamplePoints(PickupCoil pickupCoil) {
            Point2D[] point2DArray = new Point2D[this._numberOfSamplePoints];
            double d = (this._numberOfSamplePoints - 1) / 2;
            double d2 = pickupCoil.getRadius() / d;
            int n = 0;
            point2DArray[n++] = new Point2D.Double(0.0, 0.0);
            double d3 = 0.0;
            int n2 = 0;
            while ((double)n2 < d) {
                point2DArray[n++] = new Point2D.Double(0.0, d3 += d2);
                point2DArray[n++] = new Point2D.Double(0.0, -d3);
                ++n2;
            }
            return point2DArray;
        }
    }

    public static interface SamplePointsStrategy {
        public Point2D[] createSamplePoints(PickupCoil var1);
    }
}

